/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayInner;
import com.azure.resourcemanager.network.models.ManagedRulesDefinition;
import com.azure.resourcemanager.network.models.PolicySettings;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.WebApplicationFirewallCustomRule;
import com.azure.resourcemanager.network.models.WebApplicationFirewallPolicyResourceState;
import java.io.IOException;
import java.util.List;

public final class WebApplicationFirewallPolicyPropertiesFormat
implements JsonSerializable<WebApplicationFirewallPolicyPropertiesFormat> {
    private PolicySettings policySettings;
    private List<WebApplicationFirewallCustomRule> customRules;
    private List<ApplicationGatewayInner> applicationGateways;
    private ProvisioningState provisioningState;
    private WebApplicationFirewallPolicyResourceState resourceState;
    private ManagedRulesDefinition managedRules;
    private List<SubResource> httpListeners;
    private List<SubResource> pathBasedRules;
    private static final ClientLogger LOGGER = new ClientLogger(WebApplicationFirewallPolicyPropertiesFormat.class);

    public PolicySettings policySettings() {
        return this.policySettings;
    }

    public WebApplicationFirewallPolicyPropertiesFormat withPolicySettings(PolicySettings policySettings) {
        this.policySettings = policySettings;
        return this;
    }

    public List<WebApplicationFirewallCustomRule> customRules() {
        return this.customRules;
    }

    public WebApplicationFirewallPolicyPropertiesFormat withCustomRules(List<WebApplicationFirewallCustomRule> customRules) {
        this.customRules = customRules;
        return this;
    }

    public List<ApplicationGatewayInner> applicationGateways() {
        return this.applicationGateways;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public WebApplicationFirewallPolicyResourceState resourceState() {
        return this.resourceState;
    }

    public ManagedRulesDefinition managedRules() {
        return this.managedRules;
    }

    public WebApplicationFirewallPolicyPropertiesFormat withManagedRules(ManagedRulesDefinition managedRules) {
        this.managedRules = managedRules;
        return this;
    }

    public List<SubResource> httpListeners() {
        return this.httpListeners;
    }

    public List<SubResource> pathBasedRules() {
        return this.pathBasedRules;
    }

    public void validate() {
        if (this.policySettings() != null) {
            this.policySettings().validate();
        }
        if (this.customRules() != null) {
            this.customRules().forEach(e -> e.validate());
        }
        if (this.applicationGateways() != null) {
            this.applicationGateways().forEach(e -> e.validate());
        }
        if (this.managedRules() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property managedRules in model WebApplicationFirewallPolicyPropertiesFormat"));
        }
        this.managedRules().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("managedRules", (JsonSerializable)this.managedRules);
        jsonWriter.writeJsonField("policySettings", (JsonSerializable)this.policySettings);
        jsonWriter.writeArrayField("customRules", this.customRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static WebApplicationFirewallPolicyPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (WebApplicationFirewallPolicyPropertiesFormat)jsonReader.readObject(reader -> {
            WebApplicationFirewallPolicyPropertiesFormat deserializedWebApplicationFirewallPolicyPropertiesFormat = new WebApplicationFirewallPolicyPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("managedRules".equals(fieldName)) {
                    deserializedWebApplicationFirewallPolicyPropertiesFormat.managedRules = ManagedRulesDefinition.fromJson(reader);
                    continue;
                }
                if ("policySettings".equals(fieldName)) {
                    deserializedWebApplicationFirewallPolicyPropertiesFormat.policySettings = PolicySettings.fromJson(reader);
                    continue;
                }
                if ("customRules".equals(fieldName)) {
                    List customRules;
                    deserializedWebApplicationFirewallPolicyPropertiesFormat.customRules = customRules = reader.readArray(reader1 -> WebApplicationFirewallCustomRule.fromJson(reader1));
                    continue;
                }
                if ("applicationGateways".equals(fieldName)) {
                    List applicationGateways;
                    deserializedWebApplicationFirewallPolicyPropertiesFormat.applicationGateways = applicationGateways = reader.readArray(reader1 -> ApplicationGatewayInner.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedWebApplicationFirewallPolicyPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceState".equals(fieldName)) {
                    deserializedWebApplicationFirewallPolicyPropertiesFormat.resourceState = WebApplicationFirewallPolicyResourceState.fromString(reader.getString());
                    continue;
                }
                if ("httpListeners".equals(fieldName)) {
                    List httpListeners;
                    deserializedWebApplicationFirewallPolicyPropertiesFormat.httpListeners = httpListeners = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("pathBasedRules".equals(fieldName)) {
                    List pathBasedRules;
                    deserializedWebApplicationFirewallPolicyPropertiesFormat.pathBasedRules = pathBasedRules = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebApplicationFirewallPolicyPropertiesFormat;
        });
    }
}

