/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ConnectivityConfigurationProperties;
import com.azure.resourcemanager.network.models.ConfigurationGroup;
import com.azure.resourcemanager.network.models.ConnectivityGroupItem;
import com.azure.resourcemanager.network.models.ConnectivityTopology;
import com.azure.resourcemanager.network.models.DeleteExistingPeering;
import com.azure.resourcemanager.network.models.EffectiveConnectivityConfiguration;
import com.azure.resourcemanager.network.models.Hub;
import com.azure.resourcemanager.network.models.IsGlobal;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class ActiveConnectivityConfiguration
extends EffectiveConnectivityConfiguration {
    private OffsetDateTime commitTime;
    private String region;
    private ConnectivityConfigurationProperties innerProperties;

    public OffsetDateTime commitTime() {
        return this.commitTime;
    }

    public ActiveConnectivityConfiguration withCommitTime(OffsetDateTime commitTime) {
        this.commitTime = commitTime;
        return this;
    }

    public String region() {
        return this.region;
    }

    public ActiveConnectivityConfiguration withRegion(String region) {
        this.region = region;
        return this;
    }

    private ConnectivityConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public ActiveConnectivityConfiguration withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public ActiveConnectivityConfiguration withConfigurationGroups(List<ConfigurationGroup> configurationGroups) {
        super.withConfigurationGroups(configurationGroups);
        return this;
    }

    @Override
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    @Override
    public ActiveConnectivityConfiguration withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectivityConfigurationProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    @Override
    public ConnectivityTopology connectivityTopology() {
        return this.innerProperties() == null ? null : this.innerProperties().connectivityTopology();
    }

    @Override
    public ActiveConnectivityConfiguration withConnectivityTopology(ConnectivityTopology connectivityTopology) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectivityConfigurationProperties();
        }
        this.innerProperties().withConnectivityTopology(connectivityTopology);
        return this;
    }

    @Override
    public List<Hub> hubs() {
        return this.innerProperties() == null ? null : this.innerProperties().hubs();
    }

    @Override
    public ActiveConnectivityConfiguration withHubs(List<Hub> hubs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectivityConfigurationProperties();
        }
        this.innerProperties().withHubs(hubs);
        return this;
    }

    @Override
    public IsGlobal isGlobal() {
        return this.innerProperties() == null ? null : this.innerProperties().isGlobal();
    }

    @Override
    public ActiveConnectivityConfiguration withIsGlobal(IsGlobal isGlobal) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectivityConfigurationProperties();
        }
        this.innerProperties().withIsGlobal(isGlobal);
        return this;
    }

    @Override
    public List<ConnectivityGroupItem> appliesToGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().appliesToGroups();
    }

    @Override
    public ActiveConnectivityConfiguration withAppliesToGroups(List<ConnectivityGroupItem> appliesToGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectivityConfigurationProperties();
        }
        this.innerProperties().withAppliesToGroups(appliesToGroups);
        return this;
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    @Override
    public DeleteExistingPeering deleteExistingPeering() {
        return this.innerProperties() == null ? null : this.innerProperties().deleteExistingPeering();
    }

    @Override
    public ActiveConnectivityConfiguration withDeleteExistingPeering(DeleteExistingPeering deleteExistingPeering) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectivityConfigurationProperties();
        }
        this.innerProperties().withDeleteExistingPeering(deleteExistingPeering);
        return this;
    }

    @Override
    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties());
        jsonWriter.writeArrayField("configurationGroups", this.configurationGroups(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("commitTime", this.commitTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.commitTime));
        jsonWriter.writeStringField("region", this.region);
        return jsonWriter.writeEndObject();
    }

    public static ActiveConnectivityConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (ActiveConnectivityConfiguration)jsonReader.readObject(reader -> {
            ActiveConnectivityConfiguration deserializedActiveConnectivityConfiguration = new ActiveConnectivityConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedActiveConnectivityConfiguration.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedActiveConnectivityConfiguration.innerProperties = ConnectivityConfigurationProperties.fromJson(reader);
                    continue;
                }
                if ("configurationGroups".equals(fieldName)) {
                    List configurationGroups = reader.readArray(reader1 -> ConfigurationGroup.fromJson(reader1));
                    deserializedActiveConnectivityConfiguration.withConfigurationGroups(configurationGroups);
                    continue;
                }
                if ("commitTime".equals(fieldName)) {
                    deserializedActiveConnectivityConfiguration.commitTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("region".equals(fieldName)) {
                    deserializedActiveConnectivityConfiguration.region = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedActiveConnectivityConfiguration;
        });
    }
}

