/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayFirewallRuleSetPropertiesFormat;
import com.azure.resourcemanager.network.models.ApplicationGatewayFirewallRuleGroup;
import com.azure.resourcemanager.network.models.ApplicationGatewayTierTypes;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ApplicationGatewayFirewallRuleSet
extends Resource {
    private ApplicationGatewayFirewallRuleSetPropertiesFormat innerProperties;
    private String id;
    private String name;
    private String type;

    private ApplicationGatewayFirewallRuleSetPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String id() {
        return this.id;
    }

    public ApplicationGatewayFirewallRuleSet withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public ApplicationGatewayFirewallRuleSet withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ApplicationGatewayFirewallRuleSet withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String ruleSetType() {
        return this.innerProperties() == null ? null : this.innerProperties().ruleSetType();
    }

    public ApplicationGatewayFirewallRuleSet withRuleSetType(String ruleSetType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayFirewallRuleSetPropertiesFormat();
        }
        this.innerProperties().withRuleSetType(ruleSetType);
        return this;
    }

    public String ruleSetVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().ruleSetVersion();
    }

    public ApplicationGatewayFirewallRuleSet withRuleSetVersion(String ruleSetVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayFirewallRuleSetPropertiesFormat();
        }
        this.innerProperties().withRuleSetVersion(ruleSetVersion);
        return this;
    }

    public List<ApplicationGatewayFirewallRuleGroup> ruleGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().ruleGroups();
    }

    public ApplicationGatewayFirewallRuleSet withRuleGroups(List<ApplicationGatewayFirewallRuleGroup> ruleGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayFirewallRuleSetPropertiesFormat();
        }
        this.innerProperties().withRuleGroups(ruleGroups);
        return this;
    }

    public List<ApplicationGatewayTierTypes> tiers() {
        return this.innerProperties() == null ? null : this.innerProperties().tiers();
    }

    public ApplicationGatewayFirewallRuleSet withTiers(List<ApplicationGatewayTierTypes> tiers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayFirewallRuleSetPropertiesFormat();
        }
        this.innerProperties().withTiers(tiers);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGatewayFirewallRuleSet fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGatewayFirewallRuleSet)((Object)jsonReader.readObject(reader -> {
            ApplicationGatewayFirewallRuleSet deserializedApplicationGatewayFirewallRuleSet = new ApplicationGatewayFirewallRuleSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRuleSet.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRuleSet.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRuleSet.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedApplicationGatewayFirewallRuleSet.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRuleSet.innerProperties = ApplicationGatewayFirewallRuleSetPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallRuleSet.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGatewayFirewallRuleSet;
        }));
    }
}

