/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.FirewallPolicyFilterRuleCollectionAction;
import com.azure.resourcemanager.network.models.FirewallPolicyRule;
import com.azure.resourcemanager.network.models.FirewallPolicyRuleCollection;
import com.azure.resourcemanager.network.models.FirewallPolicyRuleCollectionType;
import java.io.IOException;
import java.util.List;

public final class FirewallPolicyFilterRuleCollection
extends FirewallPolicyRuleCollection {
    private FirewallPolicyRuleCollectionType ruleCollectionType = FirewallPolicyRuleCollectionType.FIREWALL_POLICY_FILTER_RULE_COLLECTION;
    private FirewallPolicyFilterRuleCollectionAction action;
    private List<FirewallPolicyRule> rules;

    @Override
    public FirewallPolicyRuleCollectionType ruleCollectionType() {
        return this.ruleCollectionType;
    }

    public FirewallPolicyFilterRuleCollectionAction action() {
        return this.action;
    }

    public FirewallPolicyFilterRuleCollection withAction(FirewallPolicyFilterRuleCollectionAction action) {
        this.action = action;
        return this;
    }

    public List<FirewallPolicyRule> rules() {
        return this.rules;
    }

    public FirewallPolicyFilterRuleCollection withRules(List<FirewallPolicyRule> rules) {
        this.rules = rules;
        return this;
    }

    @Override
    public FirewallPolicyFilterRuleCollection withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public FirewallPolicyFilterRuleCollection withPriority(Integer priority) {
        super.withPriority(priority);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.action() != null) {
            this.action().validate();
        }
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeNumberField("priority", (Number)this.priority());
        jsonWriter.writeStringField("ruleCollectionType", this.ruleCollectionType == null ? null : this.ruleCollectionType.toString());
        jsonWriter.writeJsonField("action", (JsonSerializable)this.action);
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static FirewallPolicyFilterRuleCollection fromJson(JsonReader jsonReader) throws IOException {
        return (FirewallPolicyFilterRuleCollection)jsonReader.readObject(reader -> {
            FirewallPolicyFilterRuleCollection deserializedFirewallPolicyFilterRuleCollection = new FirewallPolicyFilterRuleCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedFirewallPolicyFilterRuleCollection.withName(reader.getString());
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedFirewallPolicyFilterRuleCollection.withPriority((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("ruleCollectionType".equals(fieldName)) {
                    deserializedFirewallPolicyFilterRuleCollection.ruleCollectionType = FirewallPolicyRuleCollectionType.fromString(reader.getString());
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedFirewallPolicyFilterRuleCollection.action = FirewallPolicyFilterRuleCollectionAction.fromJson(reader);
                    continue;
                }
                if ("rules".equals(fieldName)) {
                    List rules;
                    deserializedFirewallPolicyFilterRuleCollection.rules = rules = reader.readArray(reader1 -> FirewallPolicyRule.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFirewallPolicyFilterRuleCollection;
        });
    }
}

