/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class VM
extends Resource {
    private String id;
    private String name;
    private String type;

    public String id() {
        return this.id;
    }

    public VM withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public VM withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VM withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static VM fromJson(JsonReader jsonReader) throws IOException {
        return (VM)((Object)jsonReader.readObject(reader -> {
            VM deserializedVM = new VM();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVM.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVM.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedVM.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVM.withTags(tags);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedVM.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVM;
        }));
    }
}

