/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class BastionHostIpConfigurationPropertiesFormat
implements JsonSerializable<BastionHostIpConfigurationPropertiesFormat> {
    private SubResource subnet;
    private SubResource publicIpAddress;
    private ProvisioningState provisioningState;
    private IpAllocationMethod privateIpAllocationMethod;
    private static final ClientLogger LOGGER = new ClientLogger(BastionHostIpConfigurationPropertiesFormat.class);

    public SubResource subnet() {
        return this.subnet;
    }

    public BastionHostIpConfigurationPropertiesFormat withSubnet(SubResource subnet) {
        this.subnet = subnet;
        return this;
    }

    public SubResource publicIpAddress() {
        return this.publicIpAddress;
    }

    public BastionHostIpConfigurationPropertiesFormat withPublicIpAddress(SubResource publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public IpAllocationMethod privateIpAllocationMethod() {
        return this.privateIpAllocationMethod;
    }

    public BastionHostIpConfigurationPropertiesFormat withPrivateIpAllocationMethod(IpAllocationMethod privateIpAllocationMethod) {
        this.privateIpAllocationMethod = privateIpAllocationMethod;
        return this;
    }

    public void validate() {
        if (this.subnet() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subnet in model BastionHostIpConfigurationPropertiesFormat"));
        }
        if (this.publicIpAddress() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property publicIpAddress in model BastionHostIpConfigurationPropertiesFormat"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("subnet", (JsonSerializable)this.subnet);
        jsonWriter.writeJsonField("publicIPAddress", (JsonSerializable)this.publicIpAddress);
        jsonWriter.writeStringField("privateIPAllocationMethod", this.privateIpAllocationMethod == null ? null : this.privateIpAllocationMethod.toString());
        return jsonWriter.writeEndObject();
    }

    public static BastionHostIpConfigurationPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (BastionHostIpConfigurationPropertiesFormat)jsonReader.readObject(reader -> {
            BastionHostIpConfigurationPropertiesFormat deserializedBastionHostIpConfigurationPropertiesFormat = new BastionHostIpConfigurationPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subnet".equals(fieldName)) {
                    deserializedBastionHostIpConfigurationPropertiesFormat.subnet = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("publicIPAddress".equals(fieldName)) {
                    deserializedBastionHostIpConfigurationPropertiesFormat.publicIpAddress = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedBastionHostIpConfigurationPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("privateIPAllocationMethod".equals(fieldName)) {
                    deserializedBastionHostIpConfigurationPropertiesFormat.privateIpAllocationMethod = IpAllocationMethod.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBastionHostIpConfigurationPropertiesFormat;
        });
    }
}

