/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ConfigurationType;
import com.azure.resourcemanager.network.models.NetworkManagerPropertiesNetworkManagerScopes;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class NetworkManagerProperties
implements JsonSerializable<NetworkManagerProperties> {
    private String description;
    private NetworkManagerPropertiesNetworkManagerScopes networkManagerScopes;
    private List<ConfigurationType> networkManagerScopeAccesses;
    private ProvisioningState provisioningState;
    private String resourceGuid;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkManagerProperties.class);

    public String description() {
        return this.description;
    }

    public NetworkManagerProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public NetworkManagerPropertiesNetworkManagerScopes networkManagerScopes() {
        return this.networkManagerScopes;
    }

    public NetworkManagerProperties withNetworkManagerScopes(NetworkManagerPropertiesNetworkManagerScopes networkManagerScopes) {
        this.networkManagerScopes = networkManagerScopes;
        return this;
    }

    public List<ConfigurationType> networkManagerScopeAccesses() {
        return this.networkManagerScopeAccesses;
    }

    public NetworkManagerProperties withNetworkManagerScopeAccesses(List<ConfigurationType> networkManagerScopeAccesses) {
        this.networkManagerScopeAccesses = networkManagerScopeAccesses;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public void validate() {
        if (this.networkManagerScopes() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property networkManagerScopes in model NetworkManagerProperties"));
        }
        this.networkManagerScopes().validate();
        if (this.networkManagerScopeAccesses() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property networkManagerScopeAccesses in model NetworkManagerProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("networkManagerScopes", (JsonSerializable)this.networkManagerScopes);
        jsonWriter.writeArrayField("networkManagerScopeAccesses", this.networkManagerScopeAccesses, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static NetworkManagerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkManagerProperties)jsonReader.readObject(reader -> {
            NetworkManagerProperties deserializedNetworkManagerProperties = new NetworkManagerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("networkManagerScopes".equals(fieldName)) {
                    deserializedNetworkManagerProperties.networkManagerScopes = NetworkManagerPropertiesNetworkManagerScopes.fromJson(reader);
                    continue;
                }
                if ("networkManagerScopeAccesses".equals(fieldName)) {
                    List networkManagerScopeAccesses;
                    deserializedNetworkManagerProperties.networkManagerScopeAccesses = networkManagerScopeAccesses = reader.readArray(reader1 -> ConfigurationType.fromString(reader1.getString()));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedNetworkManagerProperties.description = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkManagerProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedNetworkManagerProperties.resourceGuid = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkManagerProperties;
        });
    }
}

