/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ConnectivitySource
implements JsonSerializable<ConnectivitySource> {
    private String resourceId;
    private Integer port;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectivitySource.class);

    public String resourceId() {
        return this.resourceId;
    }

    public ConnectivitySource withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public Integer port() {
        return this.port;
    }

    public ConnectivitySource withPort(Integer port) {
        this.port = port;
        return this;
    }

    public void validate() {
        if (this.resourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceId in model ConnectivitySource"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeNumberField("port", (Number)this.port);
        return jsonWriter.writeEndObject();
    }

    public static ConnectivitySource fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectivitySource)jsonReader.readObject(reader -> {
            ConnectivitySource deserializedConnectivitySource = new ConnectivitySource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceId".equals(fieldName)) {
                    deserializedConnectivitySource.resourceId = reader.getString();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedConnectivitySource.port = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectivitySource;
        });
    }
}

