/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.IpAllocationInner;
import java.io.IOException;
import java.util.List;

public final class IpAllocationListResult
implements JsonSerializable<IpAllocationListResult> {
    private List<IpAllocationInner> value;
    private String nextLink;

    public List<IpAllocationInner> value() {
        return this.value;
    }

    public IpAllocationListResult withValue(List<IpAllocationInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public IpAllocationListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static IpAllocationListResult fromJson(JsonReader jsonReader) throws IOException {
        return (IpAllocationListResult)jsonReader.readObject(reader -> {
            IpAllocationListResult deserializedIpAllocationListResult = new IpAllocationListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedIpAllocationListResult.value = value = reader.readArray(reader1 -> IpAllocationInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedIpAllocationListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIpAllocationListResult;
        });
    }
}

