// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.NetworkManagerSecurityGroupItem;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Defines the admin rule collection properties.
 */
@Fluent
public final class AdminRuleCollectionPropertiesFormat
    implements JsonSerializable<AdminRuleCollectionPropertiesFormat> {
    /*
     * A description of the admin rule collection.
     */
    private String description;

    /*
     * Groups for configuration
     */
    private List<NetworkManagerSecurityGroupItem> appliesToGroups;

    /*
     * The provisioning state of the resource.
     */
    private ProvisioningState provisioningState;

    /*
     * Unique identifier for this resource.
     */
    private String resourceGuid;

    /**
     * Creates an instance of AdminRuleCollectionPropertiesFormat class.
     */
    public AdminRuleCollectionPropertiesFormat() {
    }

    /**
     * Get the description property: A description of the admin rule collection.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: A description of the admin rule collection.
     * 
     * @param description the description value to set.
     * @return the AdminRuleCollectionPropertiesFormat object itself.
     */
    public AdminRuleCollectionPropertiesFormat withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the appliesToGroups property: Groups for configuration.
     * 
     * @return the appliesToGroups value.
     */
    public List<NetworkManagerSecurityGroupItem> appliesToGroups() {
        return this.appliesToGroups;
    }

    /**
     * Set the appliesToGroups property: Groups for configuration.
     * 
     * @param appliesToGroups the appliesToGroups value to set.
     * @return the AdminRuleCollectionPropertiesFormat object itself.
     */
    public AdminRuleCollectionPropertiesFormat
        withAppliesToGroups(List<NetworkManagerSecurityGroupItem> appliesToGroups) {
        this.appliesToGroups = appliesToGroups;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the resourceGuid property: Unique identifier for this resource.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.resourceGuid;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (appliesToGroups() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property appliesToGroups in model AdminRuleCollectionPropertiesFormat"));
        } else {
            appliesToGroups().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AdminRuleCollectionPropertiesFormat.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("appliesToGroups", this.appliesToGroups,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AdminRuleCollectionPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AdminRuleCollectionPropertiesFormat if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AdminRuleCollectionPropertiesFormat.
     */
    public static AdminRuleCollectionPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AdminRuleCollectionPropertiesFormat deserializedAdminRuleCollectionPropertiesFormat
                = new AdminRuleCollectionPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("appliesToGroups".equals(fieldName)) {
                    List<NetworkManagerSecurityGroupItem> appliesToGroups
                        = reader.readArray(reader1 -> NetworkManagerSecurityGroupItem.fromJson(reader1));
                    deserializedAdminRuleCollectionPropertiesFormat.appliesToGroups = appliesToGroups;
                } else if ("description".equals(fieldName)) {
                    deserializedAdminRuleCollectionPropertiesFormat.description = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedAdminRuleCollectionPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("resourceGuid".equals(fieldName)) {
                    deserializedAdminRuleCollectionPropertiesFormat.resourceGuid = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAdminRuleCollectionPropertiesFormat;
        });
    }
}
