// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The serviceName of an AvailableDelegation indicates a possible delegation for a subnet.
 */
@Fluent
public final class AvailableDelegationInner implements JsonSerializable<AvailableDelegationInner> {
    /*
     * The name of the AvailableDelegation resource.
     */
    private String name;

    /*
     * A unique identifier of the AvailableDelegation resource.
     */
    private String id;

    /*
     * Resource type.
     */
    private String type;

    /*
     * The name of the service and resource.
     */
    private String serviceName;

    /*
     * The actions permitted to the service upon delegation.
     */
    private List<String> actions;

    /**
     * Creates an instance of AvailableDelegationInner class.
     */
    public AvailableDelegationInner() {
    }

    /**
     * Get the name property: The name of the AvailableDelegation resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the AvailableDelegation resource.
     * 
     * @param name the name value to set.
     * @return the AvailableDelegationInner object itself.
     */
    public AvailableDelegationInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the id property: A unique identifier of the AvailableDelegation resource.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: A unique identifier of the AvailableDelegation resource.
     * 
     * @param id the id value to set.
     * @return the AvailableDelegationInner object itself.
     */
    public AvailableDelegationInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the type property: Resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Resource type.
     * 
     * @param type the type value to set.
     * @return the AvailableDelegationInner object itself.
     */
    public AvailableDelegationInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the serviceName property: The name of the service and resource.
     * 
     * @return the serviceName value.
     */
    public String serviceName() {
        return this.serviceName;
    }

    /**
     * Set the serviceName property: The name of the service and resource.
     * 
     * @param serviceName the serviceName value to set.
     * @return the AvailableDelegationInner object itself.
     */
    public AvailableDelegationInner withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    /**
     * Get the actions property: The actions permitted to the service upon delegation.
     * 
     * @return the actions value.
     */
    public List<String> actions() {
        return this.actions;
    }

    /**
     * Set the actions property: The actions permitted to the service upon delegation.
     * 
     * @param actions the actions value to set.
     * @return the AvailableDelegationInner object itself.
     */
    public AvailableDelegationInner withActions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("serviceName", this.serviceName);
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AvailableDelegationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AvailableDelegationInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AvailableDelegationInner.
     */
    public static AvailableDelegationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AvailableDelegationInner deserializedAvailableDelegationInner = new AvailableDelegationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedAvailableDelegationInner.name = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedAvailableDelegationInner.id = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAvailableDelegationInner.type = reader.getString();
                } else if ("serviceName".equals(fieldName)) {
                    deserializedAvailableDelegationInner.serviceName = reader.getString();
                } else if ("actions".equals(fieldName)) {
                    List<String> actions = reader.readArray(reader1 -> reader1.getString());
                    deserializedAvailableDelegationInner.actions = actions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAvailableDelegationInner;
        });
    }
}
