// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AvailableProvidersListCountry;
import java.io.IOException;
import java.util.List;

/**
 * List of available countries with details.
 */
@Fluent
public final class AvailableProvidersListInner implements JsonSerializable<AvailableProvidersListInner> {
    /*
     * List of available countries.
     */
    private List<AvailableProvidersListCountry> countries;

    /**
     * Creates an instance of AvailableProvidersListInner class.
     */
    public AvailableProvidersListInner() {
    }

    /**
     * Get the countries property: List of available countries.
     * 
     * @return the countries value.
     */
    public List<AvailableProvidersListCountry> countries() {
        return this.countries;
    }

    /**
     * Set the countries property: List of available countries.
     * 
     * @param countries the countries value to set.
     * @return the AvailableProvidersListInner object itself.
     */
    public AvailableProvidersListInner withCountries(List<AvailableProvidersListCountry> countries) {
        this.countries = countries;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (countries() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property countries in model AvailableProvidersListInner"));
        } else {
            countries().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AvailableProvidersListInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("countries", this.countries, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AvailableProvidersListInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AvailableProvidersListInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AvailableProvidersListInner.
     */
    public static AvailableProvidersListInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AvailableProvidersListInner deserializedAvailableProvidersListInner = new AvailableProvidersListInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("countries".equals(fieldName)) {
                    List<AvailableProvidersListCountry> countries
                        = reader.readArray(reader1 -> AvailableProvidersListCountry.fromJson(reader1));
                    deserializedAvailableProvidersListInner.countries = countries;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAvailableProvidersListInner;
        });
    }
}
