// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Endpoint service.
 */
@Fluent
public final class EndpointServiceResultInner extends SubResource {
    /*
     * Name of the endpoint service.
     */
    private String name;

    /*
     * Type of the endpoint service.
     */
    private String type;

    /**
     * Creates an instance of EndpointServiceResultInner class.
     */
    public EndpointServiceResultInner() {
    }

    /**
     * Get the name property: Name of the endpoint service.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: Type of the endpoint service.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public EndpointServiceResultInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EndpointServiceResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EndpointServiceResultInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EndpointServiceResultInner.
     */
    public static EndpointServiceResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EndpointServiceResultInner deserializedEndpointServiceResultInner = new EndpointServiceResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedEndpointServiceResultInner.withId(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedEndpointServiceResultInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedEndpointServiceResultInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEndpointServiceResultInner;
        });
    }
}
