// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ExpressRouteGatewayPropertiesAutoScaleConfiguration;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualHubId;
import java.io.IOException;
import java.util.List;

/**
 * ExpressRoute gateway resource properties.
 */
@Fluent
public final class ExpressRouteGatewayProperties implements JsonSerializable<ExpressRouteGatewayProperties> {
    /*
     * Configuration for auto scaling.
     */
    private ExpressRouteGatewayPropertiesAutoScaleConfiguration autoScaleConfiguration;

    /*
     * List of ExpressRoute connections to the ExpressRoute gateway.
     */
    private List<ExpressRouteConnectionInner> expressRouteConnections;

    /*
     * The provisioning state of the express route gateway resource.
     */
    private ProvisioningState provisioningState;

    /*
     * The Virtual Hub where the ExpressRoute gateway is or will be deployed.
     */
    private VirtualHubId virtualHub;

    /*
     * Configures this gateway to accept traffic from non Virtual WAN networks.
     */
    private Boolean allowNonVirtualWanTraffic;

    /**
     * Creates an instance of ExpressRouteGatewayProperties class.
     */
    public ExpressRouteGatewayProperties() {
    }

    /**
     * Get the autoScaleConfiguration property: Configuration for auto scaling.
     * 
     * @return the autoScaleConfiguration value.
     */
    public ExpressRouteGatewayPropertiesAutoScaleConfiguration autoScaleConfiguration() {
        return this.autoScaleConfiguration;
    }

    /**
     * Set the autoScaleConfiguration property: Configuration for auto scaling.
     * 
     * @param autoScaleConfiguration the autoScaleConfiguration value to set.
     * @return the ExpressRouteGatewayProperties object itself.
     */
    public ExpressRouteGatewayProperties
        withAutoScaleConfiguration(ExpressRouteGatewayPropertiesAutoScaleConfiguration autoScaleConfiguration) {
        this.autoScaleConfiguration = autoScaleConfiguration;
        return this;
    }

    /**
     * Get the expressRouteConnections property: List of ExpressRoute connections to the ExpressRoute gateway.
     * 
     * @return the expressRouteConnections value.
     */
    public List<ExpressRouteConnectionInner> expressRouteConnections() {
        return this.expressRouteConnections;
    }

    /**
     * Set the expressRouteConnections property: List of ExpressRoute connections to the ExpressRoute gateway.
     * 
     * @param expressRouteConnections the expressRouteConnections value to set.
     * @return the ExpressRouteGatewayProperties object itself.
     */
    public ExpressRouteGatewayProperties
        withExpressRouteConnections(List<ExpressRouteConnectionInner> expressRouteConnections) {
        this.expressRouteConnections = expressRouteConnections;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the express route gateway resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the virtualHub property: The Virtual Hub where the ExpressRoute gateway is or will be deployed.
     * 
     * @return the virtualHub value.
     */
    public VirtualHubId virtualHub() {
        return this.virtualHub;
    }

    /**
     * Set the virtualHub property: The Virtual Hub where the ExpressRoute gateway is or will be deployed.
     * 
     * @param virtualHub the virtualHub value to set.
     * @return the ExpressRouteGatewayProperties object itself.
     */
    public ExpressRouteGatewayProperties withVirtualHub(VirtualHubId virtualHub) {
        this.virtualHub = virtualHub;
        return this;
    }

    /**
     * Get the allowNonVirtualWanTraffic property: Configures this gateway to accept traffic from non Virtual WAN
     * networks.
     * 
     * @return the allowNonVirtualWanTraffic value.
     */
    public Boolean allowNonVirtualWanTraffic() {
        return this.allowNonVirtualWanTraffic;
    }

    /**
     * Set the allowNonVirtualWanTraffic property: Configures this gateway to accept traffic from non Virtual WAN
     * networks.
     * 
     * @param allowNonVirtualWanTraffic the allowNonVirtualWanTraffic value to set.
     * @return the ExpressRouteGatewayProperties object itself.
     */
    public ExpressRouteGatewayProperties withAllowNonVirtualWanTraffic(Boolean allowNonVirtualWanTraffic) {
        this.allowNonVirtualWanTraffic = allowNonVirtualWanTraffic;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (autoScaleConfiguration() != null) {
            autoScaleConfiguration().validate();
        }
        if (expressRouteConnections() != null) {
            expressRouteConnections().forEach(e -> e.validate());
        }
        if (virtualHub() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property virtualHub in model ExpressRouteGatewayProperties"));
        } else {
            virtualHub().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ExpressRouteGatewayProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("virtualHub", this.virtualHub);
        jsonWriter.writeJsonField("autoScaleConfiguration", this.autoScaleConfiguration);
        jsonWriter.writeArrayField("expressRouteConnections", this.expressRouteConnections,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("allowNonVirtualWanTraffic", this.allowNonVirtualWanTraffic);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteGatewayProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteGatewayProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ExpressRouteGatewayProperties.
     */
    public static ExpressRouteGatewayProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteGatewayProperties deserializedExpressRouteGatewayProperties
                = new ExpressRouteGatewayProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("virtualHub".equals(fieldName)) {
                    deserializedExpressRouteGatewayProperties.virtualHub = VirtualHubId.fromJson(reader);
                } else if ("autoScaleConfiguration".equals(fieldName)) {
                    deserializedExpressRouteGatewayProperties.autoScaleConfiguration
                        = ExpressRouteGatewayPropertiesAutoScaleConfiguration.fromJson(reader);
                } else if ("expressRouteConnections".equals(fieldName)) {
                    List<ExpressRouteConnectionInner> expressRouteConnections
                        = reader.readArray(reader1 -> ExpressRouteConnectionInner.fromJson(reader1));
                    deserializedExpressRouteGatewayProperties.expressRouteConnections = expressRouteConnections;
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedExpressRouteGatewayProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("allowNonVirtualWanTraffic".equals(fieldName)) {
                    deserializedExpressRouteGatewayProperties.allowNonVirtualWanTraffic
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteGatewayProperties;
        });
    }
}
