// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ExpressRoutePortsLocationBandwidths;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * ExpressRoutePorts Peering Location
 * 
 * Definition of the ExpressRoutePorts peering location resource.
 */
@Fluent
public final class ExpressRoutePortsLocationInner extends Resource {
    /*
     * ExpressRoutePort peering location properties.
     */
    private ExpressRoutePortsLocationPropertiesFormat innerProperties;

    /*
     * Resource ID.
     */
    private String id;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /**
     * Creates an instance of ExpressRoutePortsLocationInner class.
     */
    public ExpressRoutePortsLocationInner() {
    }

    /**
     * Get the innerProperties property: ExpressRoutePort peering location properties.
     * 
     * @return the innerProperties value.
     */
    private ExpressRoutePortsLocationPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Resource ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID.
     * 
     * @param id the id value to set.
     * @return the ExpressRoutePortsLocationInner object itself.
     */
    public ExpressRoutePortsLocationInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ExpressRoutePortsLocationInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ExpressRoutePortsLocationInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the address property: Address of peering location.
     * 
     * @return the address value.
     */
    public String address() {
        return this.innerProperties() == null ? null : this.innerProperties().address();
    }

    /**
     * Get the contact property: Contact details of peering locations.
     * 
     * @return the contact value.
     */
    public String contact() {
        return this.innerProperties() == null ? null : this.innerProperties().contact();
    }

    /**
     * Get the availableBandwidths property: The inventory of available ExpressRoutePort bandwidths.
     * 
     * @return the availableBandwidths value.
     */
    public List<ExpressRoutePortsLocationBandwidths> availableBandwidths() {
        return this.innerProperties() == null ? null : this.innerProperties().availableBandwidths();
    }

    /**
     * Set the availableBandwidths property: The inventory of available ExpressRoutePort bandwidths.
     * 
     * @param availableBandwidths the availableBandwidths value to set.
     * @return the ExpressRoutePortsLocationInner object itself.
     */
    public ExpressRoutePortsLocationInner
        withAvailableBandwidths(List<ExpressRoutePortsLocationBandwidths> availableBandwidths) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRoutePortsLocationPropertiesFormat();
        }
        this.innerProperties().withAvailableBandwidths(availableBandwidths);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the express route port location resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRoutePortsLocationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRoutePortsLocationInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ExpressRoutePortsLocationInner.
     */
    public static ExpressRoutePortsLocationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRoutePortsLocationInner deserializedExpressRoutePortsLocationInner
                = new ExpressRoutePortsLocationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedExpressRoutePortsLocationInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedExpressRoutePortsLocationInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedExpressRoutePortsLocationInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedExpressRoutePortsLocationInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedExpressRoutePortsLocationInner.innerProperties
                        = ExpressRoutePortsLocationPropertiesFormat.fromJson(reader);
                } else if ("id".equals(fieldName)) {
                    deserializedExpressRoutePortsLocationInner.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRoutePortsLocationInner;
        });
    }
}
