// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.FirewallPolicyRuleCollection;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Properties of the rule collection group.
 */
@Fluent
public final class FirewallPolicyRuleCollectionGroupProperties
    implements JsonSerializable<FirewallPolicyRuleCollectionGroupProperties> {
    /*
     * A read-only string that represents the size of the FirewallPolicyRuleCollectionGroupProperties in MB. (ex 1.2MB)
     */
    private String size;

    /*
     * Priority of the Firewall Policy Rule Collection Group resource.
     */
    private Integer priority;

    /*
     * Group of Firewall Policy rule collections.
     */
    private List<FirewallPolicyRuleCollection> ruleCollections;

    /*
     * The provisioning state of the firewall policy rule collection group resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of FirewallPolicyRuleCollectionGroupProperties class.
     */
    public FirewallPolicyRuleCollectionGroupProperties() {
    }

    /**
     * Get the size property: A read-only string that represents the size of the
     * FirewallPolicyRuleCollectionGroupProperties in MB. (ex 1.2MB).
     * 
     * @return the size value.
     */
    public String size() {
        return this.size;
    }

    /**
     * Get the priority property: Priority of the Firewall Policy Rule Collection Group resource.
     * 
     * @return the priority value.
     */
    public Integer priority() {
        return this.priority;
    }

    /**
     * Set the priority property: Priority of the Firewall Policy Rule Collection Group resource.
     * 
     * @param priority the priority value to set.
     * @return the FirewallPolicyRuleCollectionGroupProperties object itself.
     */
    public FirewallPolicyRuleCollectionGroupProperties withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Get the ruleCollections property: Group of Firewall Policy rule collections.
     * 
     * @return the ruleCollections value.
     */
    public List<FirewallPolicyRuleCollection> ruleCollections() {
        return this.ruleCollections;
    }

    /**
     * Set the ruleCollections property: Group of Firewall Policy rule collections.
     * 
     * @param ruleCollections the ruleCollections value to set.
     * @return the FirewallPolicyRuleCollectionGroupProperties object itself.
     */
    public FirewallPolicyRuleCollectionGroupProperties
        withRuleCollections(List<FirewallPolicyRuleCollection> ruleCollections) {
        this.ruleCollections = ruleCollections;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the firewall policy rule collection group resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ruleCollections() != null) {
            ruleCollections().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("priority", this.priority);
        jsonWriter.writeArrayField("ruleCollections", this.ruleCollections,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FirewallPolicyRuleCollectionGroupProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FirewallPolicyRuleCollectionGroupProperties if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FirewallPolicyRuleCollectionGroupProperties.
     */
    public static FirewallPolicyRuleCollectionGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FirewallPolicyRuleCollectionGroupProperties deserializedFirewallPolicyRuleCollectionGroupProperties
                = new FirewallPolicyRuleCollectionGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("size".equals(fieldName)) {
                    deserializedFirewallPolicyRuleCollectionGroupProperties.size = reader.getString();
                } else if ("priority".equals(fieldName)) {
                    deserializedFirewallPolicyRuleCollectionGroupProperties.priority
                        = reader.getNullable(JsonReader::getInt);
                } else if ("ruleCollections".equals(fieldName)) {
                    List<FirewallPolicyRuleCollection> ruleCollections
                        = reader.readArray(reader1 -> FirewallPolicyRuleCollection.fromJson(reader1));
                    deserializedFirewallPolicyRuleCollectionGroupProperties.ruleCollections = ruleCollections;
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedFirewallPolicyRuleCollectionGroupProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFirewallPolicyRuleCollectionGroupProperties;
        });
    }
}
