// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ChildResource;
import com.azure.resourcemanager.network.models.ScopeConnectionState;
import java.io.IOException;

/**
 * The Network Manager Connection resource.
 */
@Fluent
public final class NetworkManagerConnectionInner extends ChildResource {
    /*
     * The scope connection properties
     */
    private NetworkManagerConnectionProperties innerProperties;

    /*
     * The system metadata related to this resource.
     */
    private SystemData systemData;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of NetworkManagerConnectionInner class.
     */
    public NetworkManagerConnectionInner() {
    }

    /**
     * Get the innerProperties property: The scope connection properties.
     * 
     * @return the innerProperties value.
     */
    private NetworkManagerConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system metadata related to this resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    @Override
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the networkManagerId property: Network Manager Id.
     * 
     * @return the networkManagerId value.
     */
    public String networkManagerId() {
        return this.innerProperties() == null ? null : this.innerProperties().networkManagerId();
    }

    /**
     * Set the networkManagerId property: Network Manager Id.
     * 
     * @param networkManagerId the networkManagerId value to set.
     * @return the NetworkManagerConnectionInner object itself.
     */
    public NetworkManagerConnectionInner withNetworkManagerId(String networkManagerId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkManagerConnectionProperties();
        }
        this.innerProperties().withNetworkManagerId(networkManagerId);
        return this;
    }

    /**
     * Get the connectionState property: Connection state.
     * 
     * @return the connectionState value.
     */
    public ScopeConnectionState connectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionState();
    }

    /**
     * Get the description property: A description of the network manager connection.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: A description of the network manager connection.
     * 
     * @param description the description value to set.
     * @return the NetworkManagerConnectionInner object itself.
     */
    public NetworkManagerConnectionInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkManagerConnectionProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkManagerConnectionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkManagerConnectionInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NetworkManagerConnectionInner.
     */
    public static NetworkManagerConnectionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkManagerConnectionInner deserializedNetworkManagerConnectionInner
                = new NetworkManagerConnectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedNetworkManagerConnectionInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedNetworkManagerConnectionInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedNetworkManagerConnectionInner.type = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedNetworkManagerConnectionInner.etag = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedNetworkManagerConnectionInner.innerProperties
                        = NetworkManagerConnectionProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedNetworkManagerConnectionInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkManagerConnectionInner;
        });
    }
}
