// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RouteMapRule;
import java.io.IOException;
import java.util.List;

/**
 * The RouteMap child resource of a Virtual hub.
 */
@Fluent
public final class RouteMapInner extends SubResource {
    /*
     * Properties of the RouteMap resource.
     */
    private RouteMapProperties innerProperties;

    /*
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * Resource type.
     */
    private String type;

    /**
     * Creates an instance of RouteMapInner class.
     */
    public RouteMapInner() {
    }

    /**
     * Get the innerProperties property: Properties of the RouteMap resource.
     * 
     * @return the innerProperties value.
     */
    private RouteMapProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: Resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RouteMapInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the associatedInboundConnections property: List of connections which have this RoutMap associated for inbound
     * traffic.
     * 
     * @return the associatedInboundConnections value.
     */
    public List<String> associatedInboundConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().associatedInboundConnections();
    }

    /**
     * Set the associatedInboundConnections property: List of connections which have this RoutMap associated for inbound
     * traffic.
     * 
     * @param associatedInboundConnections the associatedInboundConnections value to set.
     * @return the RouteMapInner object itself.
     */
    public RouteMapInner withAssociatedInboundConnections(List<String> associatedInboundConnections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RouteMapProperties();
        }
        this.innerProperties().withAssociatedInboundConnections(associatedInboundConnections);
        return this;
    }

    /**
     * Get the associatedOutboundConnections property: List of connections which have this RoutMap associated for
     * outbound traffic.
     * 
     * @return the associatedOutboundConnections value.
     */
    public List<String> associatedOutboundConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().associatedOutboundConnections();
    }

    /**
     * Set the associatedOutboundConnections property: List of connections which have this RoutMap associated for
     * outbound traffic.
     * 
     * @param associatedOutboundConnections the associatedOutboundConnections value to set.
     * @return the RouteMapInner object itself.
     */
    public RouteMapInner withAssociatedOutboundConnections(List<String> associatedOutboundConnections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RouteMapProperties();
        }
        this.innerProperties().withAssociatedOutboundConnections(associatedOutboundConnections);
        return this;
    }

    /**
     * Get the rules property: List of RouteMap rules to be applied.
     * 
     * @return the rules value.
     */
    public List<RouteMapRule> rules() {
        return this.innerProperties() == null ? null : this.innerProperties().rules();
    }

    /**
     * Set the rules property: List of RouteMap rules to be applied.
     * 
     * @param rules the rules value to set.
     * @return the RouteMapInner object itself.
     */
    public RouteMapInner withRules(List<RouteMapRule> rules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RouteMapProperties();
        }
        this.innerProperties().withRules(rules);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the RouteMap resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RouteMapInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RouteMapInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RouteMapInner.
     */
    public static RouteMapInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RouteMapInner deserializedRouteMapInner = new RouteMapInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRouteMapInner.withId(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedRouteMapInner.innerProperties = RouteMapProperties.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedRouteMapInner.name = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedRouteMapInner.etag = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRouteMapInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRouteMapInner;
        });
    }
}
