// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RouteMapRule;
import java.io.IOException;
import java.util.List;

/**
 * Properties of RouteMap resource.
 */
@Fluent
public final class RouteMapProperties implements JsonSerializable<RouteMapProperties> {
    /*
     * List of connections which have this RoutMap associated for inbound traffic.
     */
    private List<String> associatedInboundConnections;

    /*
     * List of connections which have this RoutMap associated for outbound traffic.
     */
    private List<String> associatedOutboundConnections;

    /*
     * List of RouteMap rules to be applied.
     */
    private List<RouteMapRule> rules;

    /*
     * The provisioning state of the RouteMap resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of RouteMapProperties class.
     */
    public RouteMapProperties() {
    }

    /**
     * Get the associatedInboundConnections property: List of connections which have this RoutMap associated for inbound
     * traffic.
     * 
     * @return the associatedInboundConnections value.
     */
    public List<String> associatedInboundConnections() {
        return this.associatedInboundConnections;
    }

    /**
     * Set the associatedInboundConnections property: List of connections which have this RoutMap associated for inbound
     * traffic.
     * 
     * @param associatedInboundConnections the associatedInboundConnections value to set.
     * @return the RouteMapProperties object itself.
     */
    public RouteMapProperties withAssociatedInboundConnections(List<String> associatedInboundConnections) {
        this.associatedInboundConnections = associatedInboundConnections;
        return this;
    }

    /**
     * Get the associatedOutboundConnections property: List of connections which have this RoutMap associated for
     * outbound traffic.
     * 
     * @return the associatedOutboundConnections value.
     */
    public List<String> associatedOutboundConnections() {
        return this.associatedOutboundConnections;
    }

    /**
     * Set the associatedOutboundConnections property: List of connections which have this RoutMap associated for
     * outbound traffic.
     * 
     * @param associatedOutboundConnections the associatedOutboundConnections value to set.
     * @return the RouteMapProperties object itself.
     */
    public RouteMapProperties withAssociatedOutboundConnections(List<String> associatedOutboundConnections) {
        this.associatedOutboundConnections = associatedOutboundConnections;
        return this;
    }

    /**
     * Get the rules property: List of RouteMap rules to be applied.
     * 
     * @return the rules value.
     */
    public List<RouteMapRule> rules() {
        return this.rules;
    }

    /**
     * Set the rules property: List of RouteMap rules to be applied.
     * 
     * @param rules the rules value to set.
     * @return the RouteMapProperties object itself.
     */
    public RouteMapProperties withRules(List<RouteMapRule> rules) {
        this.rules = rules;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the RouteMap resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (rules() != null) {
            rules().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("associatedInboundConnections", this.associatedInboundConnections,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("associatedOutboundConnections", this.associatedOutboundConnections,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RouteMapProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RouteMapProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RouteMapProperties.
     */
    public static RouteMapProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RouteMapProperties deserializedRouteMapProperties = new RouteMapProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("associatedInboundConnections".equals(fieldName)) {
                    List<String> associatedInboundConnections = reader.readArray(reader1 -> reader1.getString());
                    deserializedRouteMapProperties.associatedInboundConnections = associatedInboundConnections;
                } else if ("associatedOutboundConnections".equals(fieldName)) {
                    List<String> associatedOutboundConnections = reader.readArray(reader1 -> reader1.getString());
                    deserializedRouteMapProperties.associatedOutboundConnections = associatedOutboundConnections;
                } else if ("rules".equals(fieldName)) {
                    List<RouteMapRule> rules = reader.readArray(reader1 -> RouteMapRule.fromJson(reader1));
                    deserializedRouteMapProperties.rules = rules;
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedRouteMapProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRouteMapProperties;
        });
    }
}
