// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Route Table resource.
 */
@Fluent
public final class RouteTablePropertiesFormat implements JsonSerializable<RouteTablePropertiesFormat> {
    /*
     * Collection of routes contained within a route table.
     */
    private List<RouteInner> routes;

    /*
     * A collection of references to subnets.
     */
    private List<SubnetInner> subnets;

    /*
     * Whether to disable the routes learned by BGP on that route table. True means disable.
     */
    private Boolean disableBgpRoutePropagation;

    /*
     * The provisioning state of the route table resource.
     */
    private ProvisioningState provisioningState;

    /*
     * The resource GUID property of the route table.
     */
    private String resourceGuid;

    /**
     * Creates an instance of RouteTablePropertiesFormat class.
     */
    public RouteTablePropertiesFormat() {
    }

    /**
     * Get the routes property: Collection of routes contained within a route table.
     * 
     * @return the routes value.
     */
    public List<RouteInner> routes() {
        return this.routes;
    }

    /**
     * Set the routes property: Collection of routes contained within a route table.
     * 
     * @param routes the routes value to set.
     * @return the RouteTablePropertiesFormat object itself.
     */
    public RouteTablePropertiesFormat withRoutes(List<RouteInner> routes) {
        this.routes = routes;
        return this;
    }

    /**
     * Get the subnets property: A collection of references to subnets.
     * 
     * @return the subnets value.
     */
    public List<SubnetInner> subnets() {
        return this.subnets;
    }

    /**
     * Get the disableBgpRoutePropagation property: Whether to disable the routes learned by BGP on that route table.
     * True means disable.
     * 
     * @return the disableBgpRoutePropagation value.
     */
    public Boolean disableBgpRoutePropagation() {
        return this.disableBgpRoutePropagation;
    }

    /**
     * Set the disableBgpRoutePropagation property: Whether to disable the routes learned by BGP on that route table.
     * True means disable.
     * 
     * @param disableBgpRoutePropagation the disableBgpRoutePropagation value to set.
     * @return the RouteTablePropertiesFormat object itself.
     */
    public RouteTablePropertiesFormat withDisableBgpRoutePropagation(Boolean disableBgpRoutePropagation) {
        this.disableBgpRoutePropagation = disableBgpRoutePropagation;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the route table resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the resourceGuid property: The resource GUID property of the route table.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.resourceGuid;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (routes() != null) {
            routes().forEach(e -> e.validate());
        }
        if (subnets() != null) {
            subnets().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("routes", this.routes, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("disableBgpRoutePropagation", this.disableBgpRoutePropagation);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RouteTablePropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RouteTablePropertiesFormat if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RouteTablePropertiesFormat.
     */
    public static RouteTablePropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RouteTablePropertiesFormat deserializedRouteTablePropertiesFormat = new RouteTablePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("routes".equals(fieldName)) {
                    List<RouteInner> routes = reader.readArray(reader1 -> RouteInner.fromJson(reader1));
                    deserializedRouteTablePropertiesFormat.routes = routes;
                } else if ("subnets".equals(fieldName)) {
                    List<SubnetInner> subnets = reader.readArray(reader1 -> SubnetInner.fromJson(reader1));
                    deserializedRouteTablePropertiesFormat.subnets = subnets;
                } else if ("disableBgpRoutePropagation".equals(fieldName)) {
                    deserializedRouteTablePropertiesFormat.disableBgpRoutePropagation
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedRouteTablePropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("resourceGuid".equals(fieldName)) {
                    deserializedRouteTablePropertiesFormat.resourceGuid = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRouteTablePropertiesFormat;
        });
    }
}
