// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingRuleNextHop;
import com.azure.resourcemanager.network.models.RoutingRuleRouteDestination;
import java.io.IOException;

/**
 * Routing rule resource.
 */
@Fluent
public final class RoutingRulePropertiesFormat implements JsonSerializable<RoutingRulePropertiesFormat> {
    /*
     * A description for this rule.
     */
    private String description;

    /*
     * The provisioning state of the resource.
     */
    private ProvisioningState provisioningState;

    /*
     * Unique identifier for this resource.
     */
    private String resourceGuid;

    /*
     * Indicates the destination for this particular rule.
     */
    private RoutingRuleRouteDestination destination;

    /*
     * Indicates the next hop for this particular rule.
     */
    private RoutingRuleNextHop nextHop;

    /**
     * Creates an instance of RoutingRulePropertiesFormat class.
     */
    public RoutingRulePropertiesFormat() {
    }

    /**
     * Get the description property: A description for this rule.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: A description for this rule.
     * 
     * @param description the description value to set.
     * @return the RoutingRulePropertiesFormat object itself.
     */
    public RoutingRulePropertiesFormat withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the resourceGuid property: Unique identifier for this resource.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.resourceGuid;
    }

    /**
     * Get the destination property: Indicates the destination for this particular rule.
     * 
     * @return the destination value.
     */
    public RoutingRuleRouteDestination destination() {
        return this.destination;
    }

    /**
     * Set the destination property: Indicates the destination for this particular rule.
     * 
     * @param destination the destination value to set.
     * @return the RoutingRulePropertiesFormat object itself.
     */
    public RoutingRulePropertiesFormat withDestination(RoutingRuleRouteDestination destination) {
        this.destination = destination;
        return this;
    }

    /**
     * Get the nextHop property: Indicates the next hop for this particular rule.
     * 
     * @return the nextHop value.
     */
    public RoutingRuleNextHop nextHop() {
        return this.nextHop;
    }

    /**
     * Set the nextHop property: Indicates the next hop for this particular rule.
     * 
     * @param nextHop the nextHop value to set.
     * @return the RoutingRulePropertiesFormat object itself.
     */
    public RoutingRulePropertiesFormat withNextHop(RoutingRuleNextHop nextHop) {
        this.nextHop = nextHop;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (destination() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property destination in model RoutingRulePropertiesFormat"));
        } else {
            destination().validate();
        }
        if (nextHop() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property nextHop in model RoutingRulePropertiesFormat"));
        } else {
            nextHop().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RoutingRulePropertiesFormat.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("destination", this.destination);
        jsonWriter.writeJsonField("nextHop", this.nextHop);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoutingRulePropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoutingRulePropertiesFormat if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RoutingRulePropertiesFormat.
     */
    public static RoutingRulePropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoutingRulePropertiesFormat deserializedRoutingRulePropertiesFormat = new RoutingRulePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("destination".equals(fieldName)) {
                    deserializedRoutingRulePropertiesFormat.destination = RoutingRuleRouteDestination.fromJson(reader);
                } else if ("nextHop".equals(fieldName)) {
                    deserializedRoutingRulePropertiesFormat.nextHop = RoutingRuleNextHop.fromJson(reader);
                } else if ("description".equals(fieldName)) {
                    deserializedRoutingRulePropertiesFormat.description = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedRoutingRulePropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("resourceGuid".equals(fieldName)) {
                    deserializedRoutingRulePropertiesFormat.resourceGuid = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoutingRulePropertiesFormat;
        });
    }
}
