// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualHubRouteV2;
import java.io.IOException;
import java.util.List;

/**
 * VirtualHubRouteTableV2 Resource.
 */
@Fluent
public final class VirtualHubRouteTableV2Inner extends SubResource {
    /*
     * Properties of the virtual hub route table v2.
     */
    private VirtualHubRouteTableV2Properties innerProperties;

    /*
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /**
     * Creates an instance of VirtualHubRouteTableV2Inner class.
     */
    public VirtualHubRouteTableV2Inner() {
    }

    /**
     * Get the innerProperties property: Properties of the virtual hub route table v2.
     * 
     * @return the innerProperties value.
     */
    private VirtualHubRouteTableV2Properties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     * 
     * @param name the name value to set.
     * @return the VirtualHubRouteTableV2Inner object itself.
     */
    public VirtualHubRouteTableV2Inner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public VirtualHubRouteTableV2Inner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the routes property: List of all routes.
     * 
     * @return the routes value.
     */
    public List<VirtualHubRouteV2> routes() {
        return this.innerProperties() == null ? null : this.innerProperties().routes();
    }

    /**
     * Set the routes property: List of all routes.
     * 
     * @param routes the routes value to set.
     * @return the VirtualHubRouteTableV2Inner object itself.
     */
    public VirtualHubRouteTableV2Inner withRoutes(List<VirtualHubRouteV2> routes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualHubRouteTableV2Properties();
        }
        this.innerProperties().withRoutes(routes);
        return this;
    }

    /**
     * Get the attachedConnections property: List of all connections attached to this route table v2.
     * 
     * @return the attachedConnections value.
     */
    public List<String> attachedConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().attachedConnections();
    }

    /**
     * Set the attachedConnections property: List of all connections attached to this route table v2.
     * 
     * @param attachedConnections the attachedConnections value to set.
     * @return the VirtualHubRouteTableV2Inner object itself.
     */
    public VirtualHubRouteTableV2Inner withAttachedConnections(List<String> attachedConnections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualHubRouteTableV2Properties();
        }
        this.innerProperties().withAttachedConnections(attachedConnections);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the virtual hub route table v2 resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualHubRouteTableV2Inner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualHubRouteTableV2Inner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualHubRouteTableV2Inner.
     */
    public static VirtualHubRouteTableV2Inner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualHubRouteTableV2Inner deserializedVirtualHubRouteTableV2Inner = new VirtualHubRouteTableV2Inner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedVirtualHubRouteTableV2Inner.withId(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedVirtualHubRouteTableV2Inner.innerProperties
                        = VirtualHubRouteTableV2Properties.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedVirtualHubRouteTableV2Inner.name = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedVirtualHubRouteTableV2Inner.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualHubRouteTableV2Inner;
        });
    }
}
