// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Set of conditions in the Rewrite Rule in Application Gateway.
 */
@Fluent
public final class ApplicationGatewayRewriteRuleCondition
    implements JsonSerializable<ApplicationGatewayRewriteRuleCondition> {
    /*
     * The condition parameter of the RewriteRuleCondition.
     */
    private String variable;

    /*
     * The pattern, either fixed string or regular expression, that evaluates the truthfulness of the condition.
     */
    private String pattern;

    /*
     * Setting this parameter to truth value with force the pattern to do a case in-sensitive comparison.
     */
    private Boolean ignoreCase;

    /*
     * Setting this value as truth will force to check the negation of the condition given by the user.
     */
    private Boolean negate;

    /**
     * Creates an instance of ApplicationGatewayRewriteRuleCondition class.
     */
    public ApplicationGatewayRewriteRuleCondition() {
    }

    /**
     * Get the variable property: The condition parameter of the RewriteRuleCondition.
     * 
     * @return the variable value.
     */
    public String variable() {
        return this.variable;
    }

    /**
     * Set the variable property: The condition parameter of the RewriteRuleCondition.
     * 
     * @param variable the variable value to set.
     * @return the ApplicationGatewayRewriteRuleCondition object itself.
     */
    public ApplicationGatewayRewriteRuleCondition withVariable(String variable) {
        this.variable = variable;
        return this;
    }

    /**
     * Get the pattern property: The pattern, either fixed string or regular expression, that evaluates the truthfulness
     * of the condition.
     * 
     * @return the pattern value.
     */
    public String pattern() {
        return this.pattern;
    }

    /**
     * Set the pattern property: The pattern, either fixed string or regular expression, that evaluates the truthfulness
     * of the condition.
     * 
     * @param pattern the pattern value to set.
     * @return the ApplicationGatewayRewriteRuleCondition object itself.
     */
    public ApplicationGatewayRewriteRuleCondition withPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    /**
     * Get the ignoreCase property: Setting this parameter to truth value with force the pattern to do a case
     * in-sensitive comparison.
     * 
     * @return the ignoreCase value.
     */
    public Boolean ignoreCase() {
        return this.ignoreCase;
    }

    /**
     * Set the ignoreCase property: Setting this parameter to truth value with force the pattern to do a case
     * in-sensitive comparison.
     * 
     * @param ignoreCase the ignoreCase value to set.
     * @return the ApplicationGatewayRewriteRuleCondition object itself.
     */
    public ApplicationGatewayRewriteRuleCondition withIgnoreCase(Boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    /**
     * Get the negate property: Setting this value as truth will force to check the negation of the condition given by
     * the user.
     * 
     * @return the negate value.
     */
    public Boolean negate() {
        return this.negate;
    }

    /**
     * Set the negate property: Setting this value as truth will force to check the negation of the condition given by
     * the user.
     * 
     * @param negate the negate value to set.
     * @return the ApplicationGatewayRewriteRuleCondition object itself.
     */
    public ApplicationGatewayRewriteRuleCondition withNegate(Boolean negate) {
        this.negate = negate;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("variable", this.variable);
        jsonWriter.writeStringField("pattern", this.pattern);
        jsonWriter.writeBooleanField("ignoreCase", this.ignoreCase);
        jsonWriter.writeBooleanField("negate", this.negate);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayRewriteRuleCondition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayRewriteRuleCondition if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayRewriteRuleCondition.
     */
    public static ApplicationGatewayRewriteRuleCondition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayRewriteRuleCondition deserializedApplicationGatewayRewriteRuleCondition
                = new ApplicationGatewayRewriteRuleCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("variable".equals(fieldName)) {
                    deserializedApplicationGatewayRewriteRuleCondition.variable = reader.getString();
                } else if ("pattern".equals(fieldName)) {
                    deserializedApplicationGatewayRewriteRuleCondition.pattern = reader.getString();
                } else if ("ignoreCase".equals(fieldName)) {
                    deserializedApplicationGatewayRewriteRuleCondition.ignoreCase
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("negate".equals(fieldName)) {
                    deserializedApplicationGatewayRewriteRuleCondition.negate
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayRewriteRuleCondition;
        });
    }
}
