// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayRewriteRuleSetPropertiesFormat;
import java.io.IOException;
import java.util.List;

/**
 * Rewrite rule set of an application gateway.
 */
@Fluent
public final class ApplicationGatewayRewriteRuleSet extends SubResource {
    /*
     * Properties of the application gateway rewrite rule set.
     */
    private ApplicationGatewayRewriteRuleSetPropertiesFormat innerProperties;

    /*
     * Name of the rewrite rule set that is unique within an Application Gateway.
     */
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /**
     * Creates an instance of ApplicationGatewayRewriteRuleSet class.
     */
    public ApplicationGatewayRewriteRuleSet() {
    }

    /**
     * Get the innerProperties property: Properties of the application gateway rewrite rule set.
     * 
     * @return the innerProperties value.
     */
    private ApplicationGatewayRewriteRuleSetPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: Name of the rewrite rule set that is unique within an Application Gateway.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the rewrite rule set that is unique within an Application Gateway.
     * 
     * @param name the name value to set.
     * @return the ApplicationGatewayRewriteRuleSet object itself.
     */
    public ApplicationGatewayRewriteRuleSet withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApplicationGatewayRewriteRuleSet withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the rewriteRules property: Rewrite rules in the rewrite rule set.
     * 
     * @return the rewriteRules value.
     */
    public List<ApplicationGatewayRewriteRule> rewriteRules() {
        return this.innerProperties() == null ? null : this.innerProperties().rewriteRules();
    }

    /**
     * Set the rewriteRules property: Rewrite rules in the rewrite rule set.
     * 
     * @param rewriteRules the rewriteRules value to set.
     * @return the ApplicationGatewayRewriteRuleSet object itself.
     */
    public ApplicationGatewayRewriteRuleSet withRewriteRules(List<ApplicationGatewayRewriteRule> rewriteRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayRewriteRuleSetPropertiesFormat();
        }
        this.innerProperties().withRewriteRules(rewriteRules);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the rewrite rule set resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayRewriteRuleSet from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayRewriteRuleSet if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayRewriteRuleSet.
     */
    public static ApplicationGatewayRewriteRuleSet fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayRewriteRuleSet deserializedApplicationGatewayRewriteRuleSet
                = new ApplicationGatewayRewriteRuleSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApplicationGatewayRewriteRuleSet.withId(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedApplicationGatewayRewriteRuleSet.innerProperties
                        = ApplicationGatewayRewriteRuleSetPropertiesFormat.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedApplicationGatewayRewriteRuleSet.name = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedApplicationGatewayRewriteRuleSet.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayRewriteRuleSet;
        });
    }
}
