// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * IpGroups associated with azure firewall.
 */
@Immutable
public final class AzureFirewallIpGroups implements JsonSerializable<AzureFirewallIpGroups> {
    /*
     * Resource ID.
     */
    private String id;

    /*
     * The iteration number.
     */
    private String changeNumber;

    /**
     * Creates an instance of AzureFirewallIpGroups class.
     */
    public AzureFirewallIpGroups() {
    }

    /**
     * Get the id property: Resource ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the changeNumber property: The iteration number.
     * 
     * @return the changeNumber value.
     */
    public String changeNumber() {
        return this.changeNumber;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureFirewallIpGroups from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureFirewallIpGroups if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureFirewallIpGroups.
     */
    public static AzureFirewallIpGroups fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureFirewallIpGroups deserializedAzureFirewallIpGroups = new AzureFirewallIpGroups();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAzureFirewallIpGroups.id = reader.getString();
                } else if ("changeNumber".equals(fieldName)) {
                    deserializedAzureFirewallIpGroups.changeNumber = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureFirewallIpGroups;
        });
    }
}
