// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Request body of the CheckPrivateLinkServiceVisibility API service call.
 */
@Fluent
public final class CheckPrivateLinkServiceVisibilityRequest
    implements JsonSerializable<CheckPrivateLinkServiceVisibilityRequest> {
    /*
     * The alias of the private link service.
     */
    private String privateLinkServiceAlias;

    /**
     * Creates an instance of CheckPrivateLinkServiceVisibilityRequest class.
     */
    public CheckPrivateLinkServiceVisibilityRequest() {
    }

    /**
     * Get the privateLinkServiceAlias property: The alias of the private link service.
     * 
     * @return the privateLinkServiceAlias value.
     */
    public String privateLinkServiceAlias() {
        return this.privateLinkServiceAlias;
    }

    /**
     * Set the privateLinkServiceAlias property: The alias of the private link service.
     * 
     * @param privateLinkServiceAlias the privateLinkServiceAlias value to set.
     * @return the CheckPrivateLinkServiceVisibilityRequest object itself.
     */
    public CheckPrivateLinkServiceVisibilityRequest withPrivateLinkServiceAlias(String privateLinkServiceAlias) {
        this.privateLinkServiceAlias = privateLinkServiceAlias;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("privateLinkServiceAlias", this.privateLinkServiceAlias);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CheckPrivateLinkServiceVisibilityRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CheckPrivateLinkServiceVisibilityRequest if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CheckPrivateLinkServiceVisibilityRequest.
     */
    public static CheckPrivateLinkServiceVisibilityRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CheckPrivateLinkServiceVisibilityRequest deserializedCheckPrivateLinkServiceVisibilityRequest
                = new CheckPrivateLinkServiceVisibilityRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("privateLinkServiceAlias".equals(fieldName)) {
                    deserializedCheckPrivateLinkServiceVisibilityRequest.privateLinkServiceAlias = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCheckPrivateLinkServiceVisibilityRequest;
        });
    }
}
