// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Describes the HTTP configuration.
 */
@Fluent
public final class ConnectionMonitorHttpConfiguration implements JsonSerializable<ConnectionMonitorHttpConfiguration> {
    /*
     * The port to connect to.
     */
    private Integer port;

    /*
     * The HTTP method to use.
     */
    private HttpConfigurationMethod method;

    /*
     * The path component of the URI. For instance, "/dir1/dir2".
     */
    private String path;

    /*
     * The HTTP headers to transmit with the request.
     */
    private List<HttpHeader> requestHeaders;

    /*
     * HTTP status codes to consider successful. For instance, "2xx,301-304,418".
     */
    private List<String> validStatusCodeRanges;

    /*
     * Value indicating whether HTTPS is preferred over HTTP in cases where the choice is not explicit.
     */
    private Boolean preferHttps;

    /**
     * Creates an instance of ConnectionMonitorHttpConfiguration class.
     */
    public ConnectionMonitorHttpConfiguration() {
    }

    /**
     * Get the port property: The port to connect to.
     * 
     * @return the port value.
     */
    public Integer port() {
        return this.port;
    }

    /**
     * Set the port property: The port to connect to.
     * 
     * @param port the port value to set.
     * @return the ConnectionMonitorHttpConfiguration object itself.
     */
    public ConnectionMonitorHttpConfiguration withPort(Integer port) {
        this.port = port;
        return this;
    }

    /**
     * Get the method property: The HTTP method to use.
     * 
     * @return the method value.
     */
    public HttpConfigurationMethod method() {
        return this.method;
    }

    /**
     * Set the method property: The HTTP method to use.
     * 
     * @param method the method value to set.
     * @return the ConnectionMonitorHttpConfiguration object itself.
     */
    public ConnectionMonitorHttpConfiguration withMethod(HttpConfigurationMethod method) {
        this.method = method;
        return this;
    }

    /**
     * Get the path property: The path component of the URI. For instance, "/dir1/dir2".
     * 
     * @return the path value.
     */
    public String path() {
        return this.path;
    }

    /**
     * Set the path property: The path component of the URI. For instance, "/dir1/dir2".
     * 
     * @param path the path value to set.
     * @return the ConnectionMonitorHttpConfiguration object itself.
     */
    public ConnectionMonitorHttpConfiguration withPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * Get the requestHeaders property: The HTTP headers to transmit with the request.
     * 
     * @return the requestHeaders value.
     */
    public List<HttpHeader> requestHeaders() {
        return this.requestHeaders;
    }

    /**
     * Set the requestHeaders property: The HTTP headers to transmit with the request.
     * 
     * @param requestHeaders the requestHeaders value to set.
     * @return the ConnectionMonitorHttpConfiguration object itself.
     */
    public ConnectionMonitorHttpConfiguration withRequestHeaders(List<HttpHeader> requestHeaders) {
        this.requestHeaders = requestHeaders;
        return this;
    }

    /**
     * Get the validStatusCodeRanges property: HTTP status codes to consider successful. For instance,
     * "2xx,301-304,418".
     * 
     * @return the validStatusCodeRanges value.
     */
    public List<String> validStatusCodeRanges() {
        return this.validStatusCodeRanges;
    }

    /**
     * Set the validStatusCodeRanges property: HTTP status codes to consider successful. For instance,
     * "2xx,301-304,418".
     * 
     * @param validStatusCodeRanges the validStatusCodeRanges value to set.
     * @return the ConnectionMonitorHttpConfiguration object itself.
     */
    public ConnectionMonitorHttpConfiguration withValidStatusCodeRanges(List<String> validStatusCodeRanges) {
        this.validStatusCodeRanges = validStatusCodeRanges;
        return this;
    }

    /**
     * Get the preferHttps property: Value indicating whether HTTPS is preferred over HTTP in cases where the choice is
     * not explicit.
     * 
     * @return the preferHttps value.
     */
    public Boolean preferHttps() {
        return this.preferHttps;
    }

    /**
     * Set the preferHttps property: Value indicating whether HTTPS is preferred over HTTP in cases where the choice is
     * not explicit.
     * 
     * @param preferHttps the preferHttps value to set.
     * @return the ConnectionMonitorHttpConfiguration object itself.
     */
    public ConnectionMonitorHttpConfiguration withPreferHttps(Boolean preferHttps) {
        this.preferHttps = preferHttps;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (requestHeaders() != null) {
            requestHeaders().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("port", this.port);
        jsonWriter.writeStringField("method", this.method == null ? null : this.method.toString());
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeArrayField("requestHeaders", this.requestHeaders,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("validStatusCodeRanges", this.validStatusCodeRanges,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("preferHTTPS", this.preferHttps);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectionMonitorHttpConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectionMonitorHttpConfiguration if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectionMonitorHttpConfiguration.
     */
    public static ConnectionMonitorHttpConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectionMonitorHttpConfiguration deserializedConnectionMonitorHttpConfiguration
                = new ConnectionMonitorHttpConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("port".equals(fieldName)) {
                    deserializedConnectionMonitorHttpConfiguration.port = reader.getNullable(JsonReader::getInt);
                } else if ("method".equals(fieldName)) {
                    deserializedConnectionMonitorHttpConfiguration.method
                        = HttpConfigurationMethod.fromString(reader.getString());
                } else if ("path".equals(fieldName)) {
                    deserializedConnectionMonitorHttpConfiguration.path = reader.getString();
                } else if ("requestHeaders".equals(fieldName)) {
                    List<HttpHeader> requestHeaders = reader.readArray(reader1 -> HttpHeader.fromJson(reader1));
                    deserializedConnectionMonitorHttpConfiguration.requestHeaders = requestHeaders;
                } else if ("validStatusCodeRanges".equals(fieldName)) {
                    List<String> validStatusCodeRanges = reader.readArray(reader1 -> reader1.getString());
                    deserializedConnectionMonitorHttpConfiguration.validStatusCodeRanges = validStatusCodeRanges;
                } else if ("preferHTTPS".equals(fieldName)) {
                    deserializedConnectionMonitorHttpConfiguration.preferHttps
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectionMonitorHttpConfiguration;
        });
    }
}
