// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the source of connection monitor.
 */
@Fluent
public final class ConnectionMonitorSource implements JsonSerializable<ConnectionMonitorSource> {
    /*
     * The ID of the resource used as the source by connection monitor.
     */
    private String resourceId;

    /*
     * The source port used by connection monitor.
     */
    private Integer port;

    /**
     * Creates an instance of ConnectionMonitorSource class.
     */
    public ConnectionMonitorSource() {
    }

    /**
     * Get the resourceId property: The ID of the resource used as the source by connection monitor.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: The ID of the resource used as the source by connection monitor.
     * 
     * @param resourceId the resourceId value to set.
     * @return the ConnectionMonitorSource object itself.
     */
    public ConnectionMonitorSource withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the port property: The source port used by connection monitor.
     * 
     * @return the port value.
     */
    public Integer port() {
        return this.port;
    }

    /**
     * Set the port property: The source port used by connection monitor.
     * 
     * @param port the port value to set.
     * @return the ConnectionMonitorSource object itself.
     */
    public ConnectionMonitorSource withPort(Integer port) {
        this.port = port;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property resourceId in model ConnectionMonitorSource"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ConnectionMonitorSource.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeNumberField("port", this.port);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectionMonitorSource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectionMonitorSource if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ConnectionMonitorSource.
     */
    public static ConnectionMonitorSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectionMonitorSource deserializedConnectionMonitorSource = new ConnectionMonitorSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceId".equals(fieldName)) {
                    deserializedConnectionMonitorSource.resourceId = reader.getString();
                } else if ("port".equals(fieldName)) {
                    deserializedConnectionMonitorSource.port = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectionMonitorSource;
        });
    }
}
