// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Effective network security rules.
 */
@Fluent
public final class EffectiveNetworkSecurityRule implements JsonSerializable<EffectiveNetworkSecurityRule> {
    /*
     * The name of the security rule specified by the user (if created by the user).
     */
    private String name;

    /*
     * The network protocol this rule applies to.
     */
    private EffectiveSecurityRuleProtocol protocol;

    /*
     * The source port or range.
     */
    private String sourcePortRange;

    /*
     * The destination port or range.
     */
    private String destinationPortRange;

    /*
     * The source port ranges. Expected values include a single integer between 0 and 65535, a range using '-' as
     * separator (e.g. 100-400), or an asterisk (*).
     */
    private List<String> sourcePortRanges;

    /*
     * The destination port ranges. Expected values include a single integer between 0 and 65535, a range using '-' as
     * separator (e.g. 100-400), or an asterisk (*).
     */
    private List<String> destinationPortRanges;

    /*
     * The source address prefix.
     */
    private String sourceAddressPrefix;

    /*
     * The destination address prefix.
     */
    private String destinationAddressPrefix;

    /*
     * The source address prefixes. Expected values include CIDR IP ranges, Default Tags (VirtualNetwork,
     * AzureLoadBalancer, Internet), System Tags, and the asterisk (*).
     */
    private List<String> sourceAddressPrefixes;

    /*
     * The destination address prefixes. Expected values include CIDR IP ranges, Default Tags (VirtualNetwork,
     * AzureLoadBalancer, Internet), System Tags, and the asterisk (*).
     */
    private List<String> destinationAddressPrefixes;

    /*
     * The expanded source address prefix.
     */
    private List<String> expandedSourceAddressPrefix;

    /*
     * Expanded destination address prefix.
     */
    private List<String> expandedDestinationAddressPrefix;

    /*
     * Whether network traffic is allowed or denied.
     */
    private SecurityRuleAccess access;

    /*
     * The priority of the rule.
     */
    private Integer priority;

    /*
     * The direction of the rule.
     */
    private SecurityRuleDirection direction;

    /**
     * Creates an instance of EffectiveNetworkSecurityRule class.
     */
    public EffectiveNetworkSecurityRule() {
    }

    /**
     * Get the name property: The name of the security rule specified by the user (if created by the user).
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the security rule specified by the user (if created by the user).
     * 
     * @param name the name value to set.
     * @return the EffectiveNetworkSecurityRule object itself.
     */
    public EffectiveNetworkSecurityRule withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the protocol property: The network protocol this rule applies to.
     * 
     * @return the protocol value.
     */
    public EffectiveSecurityRuleProtocol protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol property: The network protocol this rule applies to.
     * 
     * @param protocol the protocol value to set.
     * @return the EffectiveNetworkSecurityRule object itself.
     */
    public EffectiveNetworkSecurityRule withProtocol(EffectiveSecurityRuleProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Get the sourcePortRange property: The source port or range.
     * 
     * @return the sourcePortRange value.
     */
    public String sourcePortRange() {
        return this.sourcePortRange;
    }

    /**
     * Set the sourcePortRange property: The source port or range.
     * 
     * @param sourcePortRange the sourcePortRange value to set.
     * @return the EffectiveNetworkSecurityRule object itself.
     */
    public EffectiveNetworkSecurityRule withSourcePortRange(String sourcePortRange) {
        this.sourcePortRange = sourcePortRange;
        return this;
    }

    /**
     * Get the destinationPortRange property: The destination port or range.
     * 
     * @return the destinationPortRange value.
     */
    public String destinationPortRange() {
        return this.destinationPortRange;
    }

    /**
     * Set the destinationPortRange property: The destination port or range.
     * 
     * @param destinationPortRange the destinationPortRange value to set.
     * @return the EffectiveNetworkSecurityRule object itself.
     */
    public EffectiveNetworkSecurityRule withDestinationPortRange(String destinationPortRange) {
        this.destinationPortRange = destinationPortRange;
        return this;
    }

    /**
     * Get the sourcePortRanges property: The source port ranges. Expected values include a single integer between 0 and
     * 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
     * 
     * @return the sourcePortRanges value.
     */
    public List<String> sourcePortRanges() {
        return this.sourcePortRanges;
    }

    /**
     * Set the sourcePortRanges property: The source port ranges. Expected values include a single integer between 0 and
     * 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
     * 
     * @param sourcePortRanges the sourcePortRanges value to set.
     * @return the EffectiveNetworkSecurityRule object itself.
     */
    public EffectiveNetworkSecurityRule withSourcePortRanges(List<String> sourcePortRanges) {
        this.sourcePortRanges = sourcePortRanges;
        return this;
    }

    /**
     * Get the destinationPortRanges property: The destination port ranges. Expected values include a single integer
     * between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
     * 
     * @return the destinationPortRanges value.
     */
    public List<String> destinationPortRanges() {
        return this.destinationPortRanges;
    }

    /**
     * Set the destinationPortRanges property: The destination port ranges. Expected values include a single integer
     * between 0 and 65535, a range using '-' as separator (e.g. 100-400), or an asterisk (*).
     * 
     * @param destinationPortRanges the destinationPortRanges value to set.
     * @return the EffectiveNetworkSecurityRule object itself.
     */
    public EffectiveNetworkSecurityRule withDestinationPortRanges(List<String> destinationPortRanges) {
        this.destinationPortRanges = destinationPortRanges;
        return this;
    }

    /**
     * Get the sourceAddressPrefix property: The source address prefix.
     * 
     * @return the sourceAddressPrefix value.
     */
    public String sourceAddressPrefix() {
        return this.sourceAddressPrefix;
    }

    /**
     * Set the sourceAddressPrefix property: The source address prefix.
     * 
     * @param sourceAddressPrefix the sourceAddressPrefix value to set.
     * @return the EffectiveNetworkSecurityRule object itself.
     */
    public EffectiveNetworkSecurityRule withSourceAddressPrefix(String sourceAddressPrefix) {
        this.sourceAddressPrefix = sourceAddressPrefix;
        return this;
    }

    /**
     * Get the destinationAddressPrefix property: The destination address prefix.
     * 
     * @return the destinationAddressPrefix value.
     */
    public String destinationAddressPrefix() {
        return this.destinationAddressPrefix;
    }

    /**
     * Set the destinationAddressPrefix property: The destination address prefix.
     * 
     * @param destinationAddressPrefix the destinationAddressPrefix value to set.
     * @return the EffectiveNetworkSecurityRule object itself.
     */
    public EffectiveNetworkSecurityRule withDestinationAddressPrefix(String destinationAddressPrefix) {
        this.destinationAddressPrefix = destinationAddressPrefix;
        return this;
    }

    /**
     * Get the sourceAddressPrefixes property: The source address prefixes. Expected values include CIDR IP ranges,
     * Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the asterisk (*).
     * 
     * @return the sourceAddressPrefixes value.
     */
    public List<String> sourceAddressPrefixes() {
        return this.sourceAddressPrefixes;
    }

    /**
     * Set the sourceAddressPrefixes property: The source address prefixes. Expected values include CIDR IP ranges,
     * Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the asterisk (*).
     * 
     * @param sourceAddressPrefixes the sourceAddressPrefixes value to set.
     * @return the EffectiveNetworkSecurityRule object itself.
     */
    public EffectiveNetworkSecurityRule withSourceAddressPrefixes(List<String> sourceAddressPrefixes) {
        this.sourceAddressPrefixes = sourceAddressPrefixes;
        return this;
    }

    /**
     * Get the destinationAddressPrefixes property: The destination address prefixes. Expected values include CIDR IP
     * ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the asterisk (*).
     * 
     * @return the destinationAddressPrefixes value.
     */
    public List<String> destinationAddressPrefixes() {
        return this.destinationAddressPrefixes;
    }

    /**
     * Set the destinationAddressPrefixes property: The destination address prefixes. Expected values include CIDR IP
     * ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet), System Tags, and the asterisk (*).
     * 
     * @param destinationAddressPrefixes the destinationAddressPrefixes value to set.
     * @return the EffectiveNetworkSecurityRule object itself.
     */
    public EffectiveNetworkSecurityRule withDestinationAddressPrefixes(List<String> destinationAddressPrefixes) {
        this.destinationAddressPrefixes = destinationAddressPrefixes;
        return this;
    }

    /**
     * Get the expandedSourceAddressPrefix property: The expanded source address prefix.
     * 
     * @return the expandedSourceAddressPrefix value.
     */
    public List<String> expandedSourceAddressPrefix() {
        return this.expandedSourceAddressPrefix;
    }

    /**
     * Set the expandedSourceAddressPrefix property: The expanded source address prefix.
     * 
     * @param expandedSourceAddressPrefix the expandedSourceAddressPrefix value to set.
     * @return the EffectiveNetworkSecurityRule object itself.
     */
    public EffectiveNetworkSecurityRule withExpandedSourceAddressPrefix(List<String> expandedSourceAddressPrefix) {
        this.expandedSourceAddressPrefix = expandedSourceAddressPrefix;
        return this;
    }

    /**
     * Get the expandedDestinationAddressPrefix property: Expanded destination address prefix.
     * 
     * @return the expandedDestinationAddressPrefix value.
     */
    public List<String> expandedDestinationAddressPrefix() {
        return this.expandedDestinationAddressPrefix;
    }

    /**
     * Set the expandedDestinationAddressPrefix property: Expanded destination address prefix.
     * 
     * @param expandedDestinationAddressPrefix the expandedDestinationAddressPrefix value to set.
     * @return the EffectiveNetworkSecurityRule object itself.
     */
    public EffectiveNetworkSecurityRule
        withExpandedDestinationAddressPrefix(List<String> expandedDestinationAddressPrefix) {
        this.expandedDestinationAddressPrefix = expandedDestinationAddressPrefix;
        return this;
    }

    /**
     * Get the access property: Whether network traffic is allowed or denied.
     * 
     * @return the access value.
     */
    public SecurityRuleAccess access() {
        return this.access;
    }

    /**
     * Set the access property: Whether network traffic is allowed or denied.
     * 
     * @param access the access value to set.
     * @return the EffectiveNetworkSecurityRule object itself.
     */
    public EffectiveNetworkSecurityRule withAccess(SecurityRuleAccess access) {
        this.access = access;
        return this;
    }

    /**
     * Get the priority property: The priority of the rule.
     * 
     * @return the priority value.
     */
    public Integer priority() {
        return this.priority;
    }

    /**
     * Set the priority property: The priority of the rule.
     * 
     * @param priority the priority value to set.
     * @return the EffectiveNetworkSecurityRule object itself.
     */
    public EffectiveNetworkSecurityRule withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Get the direction property: The direction of the rule.
     * 
     * @return the direction value.
     */
    public SecurityRuleDirection direction() {
        return this.direction;
    }

    /**
     * Set the direction property: The direction of the rule.
     * 
     * @param direction the direction value to set.
     * @return the EffectiveNetworkSecurityRule object itself.
     */
    public EffectiveNetworkSecurityRule withDirection(SecurityRuleDirection direction) {
        this.direction = direction;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeStringField("sourcePortRange", this.sourcePortRange);
        jsonWriter.writeStringField("destinationPortRange", this.destinationPortRange);
        jsonWriter.writeArrayField("sourcePortRanges", this.sourcePortRanges,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("destinationPortRanges", this.destinationPortRanges,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("sourceAddressPrefix", this.sourceAddressPrefix);
        jsonWriter.writeStringField("destinationAddressPrefix", this.destinationAddressPrefix);
        jsonWriter.writeArrayField("sourceAddressPrefixes", this.sourceAddressPrefixes,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("destinationAddressPrefixes", this.destinationAddressPrefixes,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("expandedSourceAddressPrefix", this.expandedSourceAddressPrefix,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("expandedDestinationAddressPrefix", this.expandedDestinationAddressPrefix,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("access", this.access == null ? null : this.access.toString());
        jsonWriter.writeNumberField("priority", this.priority);
        jsonWriter.writeStringField("direction", this.direction == null ? null : this.direction.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EffectiveNetworkSecurityRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EffectiveNetworkSecurityRule if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EffectiveNetworkSecurityRule.
     */
    public static EffectiveNetworkSecurityRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EffectiveNetworkSecurityRule deserializedEffectiveNetworkSecurityRule = new EffectiveNetworkSecurityRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedEffectiveNetworkSecurityRule.name = reader.getString();
                } else if ("protocol".equals(fieldName)) {
                    deserializedEffectiveNetworkSecurityRule.protocol
                        = EffectiveSecurityRuleProtocol.fromString(reader.getString());
                } else if ("sourcePortRange".equals(fieldName)) {
                    deserializedEffectiveNetworkSecurityRule.sourcePortRange = reader.getString();
                } else if ("destinationPortRange".equals(fieldName)) {
                    deserializedEffectiveNetworkSecurityRule.destinationPortRange = reader.getString();
                } else if ("sourcePortRanges".equals(fieldName)) {
                    List<String> sourcePortRanges = reader.readArray(reader1 -> reader1.getString());
                    deserializedEffectiveNetworkSecurityRule.sourcePortRanges = sourcePortRanges;
                } else if ("destinationPortRanges".equals(fieldName)) {
                    List<String> destinationPortRanges = reader.readArray(reader1 -> reader1.getString());
                    deserializedEffectiveNetworkSecurityRule.destinationPortRanges = destinationPortRanges;
                } else if ("sourceAddressPrefix".equals(fieldName)) {
                    deserializedEffectiveNetworkSecurityRule.sourceAddressPrefix = reader.getString();
                } else if ("destinationAddressPrefix".equals(fieldName)) {
                    deserializedEffectiveNetworkSecurityRule.destinationAddressPrefix = reader.getString();
                } else if ("sourceAddressPrefixes".equals(fieldName)) {
                    List<String> sourceAddressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedEffectiveNetworkSecurityRule.sourceAddressPrefixes = sourceAddressPrefixes;
                } else if ("destinationAddressPrefixes".equals(fieldName)) {
                    List<String> destinationAddressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedEffectiveNetworkSecurityRule.destinationAddressPrefixes = destinationAddressPrefixes;
                } else if ("expandedSourceAddressPrefix".equals(fieldName)) {
                    List<String> expandedSourceAddressPrefix = reader.readArray(reader1 -> reader1.getString());
                    deserializedEffectiveNetworkSecurityRule.expandedSourceAddressPrefix = expandedSourceAddressPrefix;
                } else if ("expandedDestinationAddressPrefix".equals(fieldName)) {
                    List<String> expandedDestinationAddressPrefix = reader.readArray(reader1 -> reader1.getString());
                    deserializedEffectiveNetworkSecurityRule.expandedDestinationAddressPrefix
                        = expandedDestinationAddressPrefix;
                } else if ("access".equals(fieldName)) {
                    deserializedEffectiveNetworkSecurityRule.access = SecurityRuleAccess.fromString(reader.getString());
                } else if ("priority".equals(fieldName)) {
                    deserializedEffectiveNetworkSecurityRule.priority = reader.getNullable(JsonReader::getInt);
                } else if ("direction".equals(fieldName)) {
                    deserializedEffectiveNetworkSecurityRule.direction
                        = SecurityRuleDirection.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEffectiveNetworkSecurityRule;
        });
    }
}
