// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteLinkInner;
import java.io.IOException;
import java.util.List;

/**
 * ExpressRouteLink List Result
 * 
 * Response for ListExpressRouteLinks API service call.
 */
@Fluent
public final class ExpressRouteLinkListResult implements JsonSerializable<ExpressRouteLinkListResult> {
    /*
     * The list of ExpressRouteLink sub-resources.
     */
    private List<ExpressRouteLinkInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of ExpressRouteLinkListResult class.
     */
    public ExpressRouteLinkListResult() {
    }

    /**
     * Get the value property: The list of ExpressRouteLink sub-resources.
     * 
     * @return the value value.
     */
    public List<ExpressRouteLinkInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of ExpressRouteLink sub-resources.
     * 
     * @param value the value value to set.
     * @return the ExpressRouteLinkListResult object itself.
     */
    public ExpressRouteLinkListResult withValue(List<ExpressRouteLinkInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ExpressRouteLinkListResult object itself.
     */
    public ExpressRouteLinkListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteLinkListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteLinkListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteLinkListResult.
     */
    public static ExpressRouteLinkListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteLinkListResult deserializedExpressRouteLinkListResult = new ExpressRouteLinkListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ExpressRouteLinkInner> value
                        = reader.readArray(reader1 -> ExpressRouteLinkInner.fromJson(reader1));
                    deserializedExpressRouteLinkListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedExpressRouteLinkListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteLinkListResult;
        });
    }
}
