// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Definition of ExpressRouteLink Mac Security configuration.
 * 
 * ExpressRouteLink Mac Security Configuration.
 */
@Fluent
public final class ExpressRouteLinkMacSecConfig implements JsonSerializable<ExpressRouteLinkMacSecConfig> {
    /*
     * Keyvault Secret Identifier URL containing Mac security CKN key.
     */
    private String cknSecretIdentifier;

    /*
     * Keyvault Secret Identifier URL containing Mac security CAK key.
     */
    private String cakSecretIdentifier;

    /*
     * Mac security cipher.
     */
    private ExpressRouteLinkMacSecCipher cipher;

    /*
     * Sci mode enabled/disabled.
     */
    private ExpressRouteLinkMacSecSciState sciState;

    /**
     * Creates an instance of ExpressRouteLinkMacSecConfig class.
     */
    public ExpressRouteLinkMacSecConfig() {
    }

    /**
     * Get the cknSecretIdentifier property: Keyvault Secret Identifier URL containing Mac security CKN key.
     * 
     * @return the cknSecretIdentifier value.
     */
    public String cknSecretIdentifier() {
        return this.cknSecretIdentifier;
    }

    /**
     * Set the cknSecretIdentifier property: Keyvault Secret Identifier URL containing Mac security CKN key.
     * 
     * @param cknSecretIdentifier the cknSecretIdentifier value to set.
     * @return the ExpressRouteLinkMacSecConfig object itself.
     */
    public ExpressRouteLinkMacSecConfig withCknSecretIdentifier(String cknSecretIdentifier) {
        this.cknSecretIdentifier = cknSecretIdentifier;
        return this;
    }

    /**
     * Get the cakSecretIdentifier property: Keyvault Secret Identifier URL containing Mac security CAK key.
     * 
     * @return the cakSecretIdentifier value.
     */
    public String cakSecretIdentifier() {
        return this.cakSecretIdentifier;
    }

    /**
     * Set the cakSecretIdentifier property: Keyvault Secret Identifier URL containing Mac security CAK key.
     * 
     * @param cakSecretIdentifier the cakSecretIdentifier value to set.
     * @return the ExpressRouteLinkMacSecConfig object itself.
     */
    public ExpressRouteLinkMacSecConfig withCakSecretIdentifier(String cakSecretIdentifier) {
        this.cakSecretIdentifier = cakSecretIdentifier;
        return this;
    }

    /**
     * Get the cipher property: Mac security cipher.
     * 
     * @return the cipher value.
     */
    public ExpressRouteLinkMacSecCipher cipher() {
        return this.cipher;
    }

    /**
     * Set the cipher property: Mac security cipher.
     * 
     * @param cipher the cipher value to set.
     * @return the ExpressRouteLinkMacSecConfig object itself.
     */
    public ExpressRouteLinkMacSecConfig withCipher(ExpressRouteLinkMacSecCipher cipher) {
        this.cipher = cipher;
        return this;
    }

    /**
     * Get the sciState property: Sci mode enabled/disabled.
     * 
     * @return the sciState value.
     */
    public ExpressRouteLinkMacSecSciState sciState() {
        return this.sciState;
    }

    /**
     * Set the sciState property: Sci mode enabled/disabled.
     * 
     * @param sciState the sciState value to set.
     * @return the ExpressRouteLinkMacSecConfig object itself.
     */
    public ExpressRouteLinkMacSecConfig withSciState(ExpressRouteLinkMacSecSciState sciState) {
        this.sciState = sciState;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("cknSecretIdentifier", this.cknSecretIdentifier);
        jsonWriter.writeStringField("cakSecretIdentifier", this.cakSecretIdentifier);
        jsonWriter.writeStringField("cipher", this.cipher == null ? null : this.cipher.toString());
        jsonWriter.writeStringField("sciState", this.sciState == null ? null : this.sciState.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteLinkMacSecConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteLinkMacSecConfig if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteLinkMacSecConfig.
     */
    public static ExpressRouteLinkMacSecConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteLinkMacSecConfig deserializedExpressRouteLinkMacSecConfig = new ExpressRouteLinkMacSecConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("cknSecretIdentifier".equals(fieldName)) {
                    deserializedExpressRouteLinkMacSecConfig.cknSecretIdentifier = reader.getString();
                } else if ("cakSecretIdentifier".equals(fieldName)) {
                    deserializedExpressRouteLinkMacSecConfig.cakSecretIdentifier = reader.getString();
                } else if ("cipher".equals(fieldName)) {
                    deserializedExpressRouteLinkMacSecConfig.cipher
                        = ExpressRouteLinkMacSecCipher.fromString(reader.getString());
                } else if ("sciState".equals(fieldName)) {
                    deserializedExpressRouteLinkMacSecConfig.sciState
                        = ExpressRouteLinkMacSecSciState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteLinkMacSecConfig;
        });
    }
}
