// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * ExpressRoutePorts Location Bandwidths
 * 
 * Real-time inventory of available ExpressRoute port bandwidths.
 */
@Immutable
public final class ExpressRoutePortsLocationBandwidths
    implements JsonSerializable<ExpressRoutePortsLocationBandwidths> {
    /*
     * Bandwidth descriptive name.
     */
    private String offerName;

    /*
     * Bandwidth value in Gbps.
     */
    private Integer valueInGbps;

    /**
     * Creates an instance of ExpressRoutePortsLocationBandwidths class.
     */
    public ExpressRoutePortsLocationBandwidths() {
    }

    /**
     * Get the offerName property: Bandwidth descriptive name.
     * 
     * @return the offerName value.
     */
    public String offerName() {
        return this.offerName;
    }

    /**
     * Get the valueInGbps property: Bandwidth value in Gbps.
     * 
     * @return the valueInGbps value.
     */
    public Integer valueInGbps() {
        return this.valueInGbps;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRoutePortsLocationBandwidths from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRoutePortsLocationBandwidths if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRoutePortsLocationBandwidths.
     */
    public static ExpressRoutePortsLocationBandwidths fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRoutePortsLocationBandwidths deserializedExpressRoutePortsLocationBandwidths
                = new ExpressRoutePortsLocationBandwidths();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("offerName".equals(fieldName)) {
                    deserializedExpressRoutePortsLocationBandwidths.offerName = reader.getString();
                } else if ("valueInGbps".equals(fieldName)) {
                    deserializedExpressRoutePortsLocationBandwidths.valueInGbps
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRoutePortsLocationBandwidths;
        });
    }
}
