// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Firewall Policy Insights.
 */
@Fluent
public final class FirewallPolicyInsights implements JsonSerializable<FirewallPolicyInsights> {
    /*
     * A flag to indicate if the insights are enabled on the policy.
     */
    private Boolean isEnabled;

    /*
     * Number of days the insights should be enabled on the policy.
     */
    private Integer retentionDays;

    /*
     * Workspaces needed to configure the Firewall Policy Insights.
     */
    private FirewallPolicyLogAnalyticsResources logAnalyticsResources;

    /**
     * Creates an instance of FirewallPolicyInsights class.
     */
    public FirewallPolicyInsights() {
    }

    /**
     * Get the isEnabled property: A flag to indicate if the insights are enabled on the policy.
     * 
     * @return the isEnabled value.
     */
    public Boolean isEnabled() {
        return this.isEnabled;
    }

    /**
     * Set the isEnabled property: A flag to indicate if the insights are enabled on the policy.
     * 
     * @param isEnabled the isEnabled value to set.
     * @return the FirewallPolicyInsights object itself.
     */
    public FirewallPolicyInsights withIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    /**
     * Get the retentionDays property: Number of days the insights should be enabled on the policy.
     * 
     * @return the retentionDays value.
     */
    public Integer retentionDays() {
        return this.retentionDays;
    }

    /**
     * Set the retentionDays property: Number of days the insights should be enabled on the policy.
     * 
     * @param retentionDays the retentionDays value to set.
     * @return the FirewallPolicyInsights object itself.
     */
    public FirewallPolicyInsights withRetentionDays(Integer retentionDays) {
        this.retentionDays = retentionDays;
        return this;
    }

    /**
     * Get the logAnalyticsResources property: Workspaces needed to configure the Firewall Policy Insights.
     * 
     * @return the logAnalyticsResources value.
     */
    public FirewallPolicyLogAnalyticsResources logAnalyticsResources() {
        return this.logAnalyticsResources;
    }

    /**
     * Set the logAnalyticsResources property: Workspaces needed to configure the Firewall Policy Insights.
     * 
     * @param logAnalyticsResources the logAnalyticsResources value to set.
     * @return the FirewallPolicyInsights object itself.
     */
    public FirewallPolicyInsights withLogAnalyticsResources(FirewallPolicyLogAnalyticsResources logAnalyticsResources) {
        this.logAnalyticsResources = logAnalyticsResources;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (logAnalyticsResources() != null) {
            logAnalyticsResources().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isEnabled", this.isEnabled);
        jsonWriter.writeNumberField("retentionDays", this.retentionDays);
        jsonWriter.writeJsonField("logAnalyticsResources", this.logAnalyticsResources);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FirewallPolicyInsights from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FirewallPolicyInsights if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FirewallPolicyInsights.
     */
    public static FirewallPolicyInsights fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FirewallPolicyInsights deserializedFirewallPolicyInsights = new FirewallPolicyInsights();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("isEnabled".equals(fieldName)) {
                    deserializedFirewallPolicyInsights.isEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("retentionDays".equals(fieldName)) {
                    deserializedFirewallPolicyInsights.retentionDays = reader.getNullable(JsonReader::getInt);
                } else if ("logAnalyticsResources".equals(fieldName)) {
                    deserializedFirewallPolicyInsights.logAnalyticsResources
                        = FirewallPolicyLogAnalyticsResources.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFirewallPolicyInsights;
        });
    }
}
