// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Log Analytics Resources for Firewall Policy Insights.
 */
@Fluent
public final class FirewallPolicyLogAnalyticsResources
    implements JsonSerializable<FirewallPolicyLogAnalyticsResources> {
    /*
     * List of workspaces for Firewall Policy Insights.
     */
    private List<FirewallPolicyLogAnalyticsWorkspace> workspaces;

    /*
     * The default workspace Id for Firewall Policy Insights.
     */
    private SubResource defaultWorkspaceId;

    /**
     * Creates an instance of FirewallPolicyLogAnalyticsResources class.
     */
    public FirewallPolicyLogAnalyticsResources() {
    }

    /**
     * Get the workspaces property: List of workspaces for Firewall Policy Insights.
     * 
     * @return the workspaces value.
     */
    public List<FirewallPolicyLogAnalyticsWorkspace> workspaces() {
        return this.workspaces;
    }

    /**
     * Set the workspaces property: List of workspaces for Firewall Policy Insights.
     * 
     * @param workspaces the workspaces value to set.
     * @return the FirewallPolicyLogAnalyticsResources object itself.
     */
    public FirewallPolicyLogAnalyticsResources withWorkspaces(List<FirewallPolicyLogAnalyticsWorkspace> workspaces) {
        this.workspaces = workspaces;
        return this;
    }

    /**
     * Get the defaultWorkspaceId property: The default workspace Id for Firewall Policy Insights.
     * 
     * @return the defaultWorkspaceId value.
     */
    public SubResource defaultWorkspaceId() {
        return this.defaultWorkspaceId;
    }

    /**
     * Set the defaultWorkspaceId property: The default workspace Id for Firewall Policy Insights.
     * 
     * @param defaultWorkspaceId the defaultWorkspaceId value to set.
     * @return the FirewallPolicyLogAnalyticsResources object itself.
     */
    public FirewallPolicyLogAnalyticsResources withDefaultWorkspaceId(SubResource defaultWorkspaceId) {
        this.defaultWorkspaceId = defaultWorkspaceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (workspaces() != null) {
            workspaces().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("workspaces", this.workspaces, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("defaultWorkspaceId", this.defaultWorkspaceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FirewallPolicyLogAnalyticsResources from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FirewallPolicyLogAnalyticsResources if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FirewallPolicyLogAnalyticsResources.
     */
    public static FirewallPolicyLogAnalyticsResources fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FirewallPolicyLogAnalyticsResources deserializedFirewallPolicyLogAnalyticsResources
                = new FirewallPolicyLogAnalyticsResources();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("workspaces".equals(fieldName)) {
                    List<FirewallPolicyLogAnalyticsWorkspace> workspaces
                        = reader.readArray(reader1 -> FirewallPolicyLogAnalyticsWorkspace.fromJson(reader1));
                    deserializedFirewallPolicyLogAnalyticsResources.workspaces = workspaces;
                } else if ("defaultWorkspaceId".equals(fieldName)) {
                    deserializedFirewallPolicyLogAnalyticsResources.defaultWorkspaceId = SubResource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFirewallPolicyLogAnalyticsResources;
        });
    }
}
