// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of the FirewallPolicyNatRuleCollectionAction.
 */
@Fluent
public final class FirewallPolicyNatRuleCollectionAction
    implements JsonSerializable<FirewallPolicyNatRuleCollectionAction> {
    /*
     * The type of action.
     */
    private FirewallPolicyNatRuleCollectionActionType type;

    /**
     * Creates an instance of FirewallPolicyNatRuleCollectionAction class.
     */
    public FirewallPolicyNatRuleCollectionAction() {
    }

    /**
     * Get the type property: The type of action.
     * 
     * @return the type value.
     */
    public FirewallPolicyNatRuleCollectionActionType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of action.
     * 
     * @param type the type value to set.
     * @return the FirewallPolicyNatRuleCollectionAction object itself.
     */
    public FirewallPolicyNatRuleCollectionAction withType(FirewallPolicyNatRuleCollectionActionType type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FirewallPolicyNatRuleCollectionAction from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FirewallPolicyNatRuleCollectionAction if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FirewallPolicyNatRuleCollectionAction.
     */
    public static FirewallPolicyNatRuleCollectionAction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FirewallPolicyNatRuleCollectionAction deserializedFirewallPolicyNatRuleCollectionAction
                = new FirewallPolicyNatRuleCollectionAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedFirewallPolicyNatRuleCollectionAction.type
                        = FirewallPolicyNatRuleCollectionActionType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFirewallPolicyNatRuleCollectionAction;
        });
    }
}
