// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * HTTP configuration of the connectivity check.
 */
@Fluent
public final class HttpConfiguration implements JsonSerializable<HttpConfiguration> {
    /*
     * HTTP method.
     */
    private HttpMethod method;

    /*
     * List of HTTP headers.
     */
    private List<HttpHeader> headers;

    /*
     * Valid status codes.
     */
    private List<Integer> validStatusCodes;

    /**
     * Creates an instance of HttpConfiguration class.
     */
    public HttpConfiguration() {
    }

    /**
     * Get the method property: HTTP method.
     * 
     * @return the method value.
     */
    public HttpMethod method() {
        return this.method;
    }

    /**
     * Set the method property: HTTP method.
     * 
     * @param method the method value to set.
     * @return the HttpConfiguration object itself.
     */
    public HttpConfiguration withMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    /**
     * Get the headers property: List of HTTP headers.
     * 
     * @return the headers value.
     */
    public List<HttpHeader> headers() {
        return this.headers;
    }

    /**
     * Set the headers property: List of HTTP headers.
     * 
     * @param headers the headers value to set.
     * @return the HttpConfiguration object itself.
     */
    public HttpConfiguration withHeaders(List<HttpHeader> headers) {
        this.headers = headers;
        return this;
    }

    /**
     * Get the validStatusCodes property: Valid status codes.
     * 
     * @return the validStatusCodes value.
     */
    public List<Integer> validStatusCodes() {
        return this.validStatusCodes;
    }

    /**
     * Set the validStatusCodes property: Valid status codes.
     * 
     * @param validStatusCodes the validStatusCodes value to set.
     * @return the HttpConfiguration object itself.
     */
    public HttpConfiguration withValidStatusCodes(List<Integer> validStatusCodes) {
        this.validStatusCodes = validStatusCodes;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (headers() != null) {
            headers().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("method", this.method == null ? null : this.method.toString());
        jsonWriter.writeArrayField("headers", this.headers, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("validStatusCodes", this.validStatusCodes,
            (writer, element) -> writer.writeInt(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HttpConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HttpConfiguration if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the HttpConfiguration.
     */
    public static HttpConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HttpConfiguration deserializedHttpConfiguration = new HttpConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("method".equals(fieldName)) {
                    deserializedHttpConfiguration.method = HttpMethod.fromString(reader.getString());
                } else if ("headers".equals(fieldName)) {
                    List<HttpHeader> headers = reader.readArray(reader1 -> HttpHeader.fromJson(reader1));
                    deserializedHttpConfiguration.headers = headers;
                } else if ("validStatusCodes".equals(fieldName)) {
                    List<Integer> validStatusCodes = reader.readArray(reader1 -> reader1.getInt());
                    deserializedHttpConfiguration.validStatusCodes = validStatusCodes;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHttpConfiguration;
        });
    }
}
