// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains IPv6 peering config.
 */
@Fluent
public final class Ipv6ExpressRouteCircuitPeeringConfig
    implements JsonSerializable<Ipv6ExpressRouteCircuitPeeringConfig> {
    /*
     * The primary address prefix.
     */
    private String primaryPeerAddressPrefix;

    /*
     * The secondary address prefix.
     */
    private String secondaryPeerAddressPrefix;

    /*
     * The Microsoft peering configuration.
     */
    private ExpressRouteCircuitPeeringConfig microsoftPeeringConfig;

    /*
     * The reference to the RouteFilter resource.
     */
    private SubResource routeFilter;

    /*
     * The state of peering.
     */
    private ExpressRouteCircuitPeeringState state;

    /**
     * Creates an instance of Ipv6ExpressRouteCircuitPeeringConfig class.
     */
    public Ipv6ExpressRouteCircuitPeeringConfig() {
    }

    /**
     * Get the primaryPeerAddressPrefix property: The primary address prefix.
     * 
     * @return the primaryPeerAddressPrefix value.
     */
    public String primaryPeerAddressPrefix() {
        return this.primaryPeerAddressPrefix;
    }

    /**
     * Set the primaryPeerAddressPrefix property: The primary address prefix.
     * 
     * @param primaryPeerAddressPrefix the primaryPeerAddressPrefix value to set.
     * @return the Ipv6ExpressRouteCircuitPeeringConfig object itself.
     */
    public Ipv6ExpressRouteCircuitPeeringConfig withPrimaryPeerAddressPrefix(String primaryPeerAddressPrefix) {
        this.primaryPeerAddressPrefix = primaryPeerAddressPrefix;
        return this;
    }

    /**
     * Get the secondaryPeerAddressPrefix property: The secondary address prefix.
     * 
     * @return the secondaryPeerAddressPrefix value.
     */
    public String secondaryPeerAddressPrefix() {
        return this.secondaryPeerAddressPrefix;
    }

    /**
     * Set the secondaryPeerAddressPrefix property: The secondary address prefix.
     * 
     * @param secondaryPeerAddressPrefix the secondaryPeerAddressPrefix value to set.
     * @return the Ipv6ExpressRouteCircuitPeeringConfig object itself.
     */
    public Ipv6ExpressRouteCircuitPeeringConfig withSecondaryPeerAddressPrefix(String secondaryPeerAddressPrefix) {
        this.secondaryPeerAddressPrefix = secondaryPeerAddressPrefix;
        return this;
    }

    /**
     * Get the microsoftPeeringConfig property: The Microsoft peering configuration.
     * 
     * @return the microsoftPeeringConfig value.
     */
    public ExpressRouteCircuitPeeringConfig microsoftPeeringConfig() {
        return this.microsoftPeeringConfig;
    }

    /**
     * Set the microsoftPeeringConfig property: The Microsoft peering configuration.
     * 
     * @param microsoftPeeringConfig the microsoftPeeringConfig value to set.
     * @return the Ipv6ExpressRouteCircuitPeeringConfig object itself.
     */
    public Ipv6ExpressRouteCircuitPeeringConfig
        withMicrosoftPeeringConfig(ExpressRouteCircuitPeeringConfig microsoftPeeringConfig) {
        this.microsoftPeeringConfig = microsoftPeeringConfig;
        return this;
    }

    /**
     * Get the routeFilter property: The reference to the RouteFilter resource.
     * 
     * @return the routeFilter value.
     */
    public SubResource routeFilter() {
        return this.routeFilter;
    }

    /**
     * Set the routeFilter property: The reference to the RouteFilter resource.
     * 
     * @param routeFilter the routeFilter value to set.
     * @return the Ipv6ExpressRouteCircuitPeeringConfig object itself.
     */
    public Ipv6ExpressRouteCircuitPeeringConfig withRouteFilter(SubResource routeFilter) {
        this.routeFilter = routeFilter;
        return this;
    }

    /**
     * Get the state property: The state of peering.
     * 
     * @return the state value.
     */
    public ExpressRouteCircuitPeeringState state() {
        return this.state;
    }

    /**
     * Set the state property: The state of peering.
     * 
     * @param state the state value to set.
     * @return the Ipv6ExpressRouteCircuitPeeringConfig object itself.
     */
    public Ipv6ExpressRouteCircuitPeeringConfig withState(ExpressRouteCircuitPeeringState state) {
        this.state = state;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (microsoftPeeringConfig() != null) {
            microsoftPeeringConfig().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("primaryPeerAddressPrefix", this.primaryPeerAddressPrefix);
        jsonWriter.writeStringField("secondaryPeerAddressPrefix", this.secondaryPeerAddressPrefix);
        jsonWriter.writeJsonField("microsoftPeeringConfig", this.microsoftPeeringConfig);
        jsonWriter.writeJsonField("routeFilter", this.routeFilter);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Ipv6ExpressRouteCircuitPeeringConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Ipv6ExpressRouteCircuitPeeringConfig if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the Ipv6ExpressRouteCircuitPeeringConfig.
     */
    public static Ipv6ExpressRouteCircuitPeeringConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Ipv6ExpressRouteCircuitPeeringConfig deserializedIpv6ExpressRouteCircuitPeeringConfig
                = new Ipv6ExpressRouteCircuitPeeringConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("primaryPeerAddressPrefix".equals(fieldName)) {
                    deserializedIpv6ExpressRouteCircuitPeeringConfig.primaryPeerAddressPrefix = reader.getString();
                } else if ("secondaryPeerAddressPrefix".equals(fieldName)) {
                    deserializedIpv6ExpressRouteCircuitPeeringConfig.secondaryPeerAddressPrefix = reader.getString();
                } else if ("microsoftPeeringConfig".equals(fieldName)) {
                    deserializedIpv6ExpressRouteCircuitPeeringConfig.microsoftPeeringConfig
                        = ExpressRouteCircuitPeeringConfig.fromJson(reader);
                } else if ("routeFilter".equals(fieldName)) {
                    deserializedIpv6ExpressRouteCircuitPeeringConfig.routeFilter = SubResource.fromJson(reader);
                } else if ("state".equals(fieldName)) {
                    deserializedIpv6ExpressRouteCircuitPeeringConfig.state
                        = ExpressRouteCircuitPeeringState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIpv6ExpressRouteCircuitPeeringConfig;
        });
    }
}
