// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.P2SVpnGatewayInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the request to list P2SVpnGateways. It contains a list of P2SVpnGateways and a URL nextLink to get the next
 * set of results.
 */
@Fluent
public final class ListP2SVpnGatewaysResult implements JsonSerializable<ListP2SVpnGatewaysResult> {
    /*
     * List of P2SVpnGateways.
     */
    private List<P2SVpnGatewayInner> value;

    /*
     * URL to get the next set of operation list results if there are any.
     */
    private String nextLink;

    /**
     * Creates an instance of ListP2SVpnGatewaysResult class.
     */
    public ListP2SVpnGatewaysResult() {
    }

    /**
     * Get the value property: List of P2SVpnGateways.
     * 
     * @return the value value.
     */
    public List<P2SVpnGatewayInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of P2SVpnGateways.
     * 
     * @param value the value value to set.
     * @return the ListP2SVpnGatewaysResult object itself.
     */
    public ListP2SVpnGatewaysResult withValue(List<P2SVpnGatewayInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: URL to get the next set of operation list results if there are any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of operation list results if there are any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ListP2SVpnGatewaysResult object itself.
     */
    public ListP2SVpnGatewaysResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListP2SVpnGatewaysResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListP2SVpnGatewaysResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ListP2SVpnGatewaysResult.
     */
    public static ListP2SVpnGatewaysResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ListP2SVpnGatewaysResult deserializedListP2SVpnGatewaysResult = new ListP2SVpnGatewaysResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<P2SVpnGatewayInner> value = reader.readArray(reader1 -> P2SVpnGatewayInner.fromJson(reader1));
                    deserializedListP2SVpnGatewaysResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedListP2SVpnGatewaysResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedListP2SVpnGatewaysResult;
        });
    }
}
