// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A RouteMap Rule.
 */
@Fluent
public final class RouteMapRule implements JsonSerializable<RouteMapRule> {
    /*
     * The unique name for the rule.
     */
    private String name;

    /*
     * List of matching criterion which will be applied to traffic.
     */
    private List<Criterion> matchCriteria;

    /*
     * List of actions which will be applied on a match.
     */
    private List<Action> actions;

    /*
     * Next step after rule is evaluated. Current supported behaviors are 'Continue'(to next rule) and 'Terminate'.
     */
    private NextStep nextStepIfMatched;

    /**
     * Creates an instance of RouteMapRule class.
     */
    public RouteMapRule() {
    }

    /**
     * Get the name property: The unique name for the rule.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The unique name for the rule.
     * 
     * @param name the name value to set.
     * @return the RouteMapRule object itself.
     */
    public RouteMapRule withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the matchCriteria property: List of matching criterion which will be applied to traffic.
     * 
     * @return the matchCriteria value.
     */
    public List<Criterion> matchCriteria() {
        return this.matchCriteria;
    }

    /**
     * Set the matchCriteria property: List of matching criterion which will be applied to traffic.
     * 
     * @param matchCriteria the matchCriteria value to set.
     * @return the RouteMapRule object itself.
     */
    public RouteMapRule withMatchCriteria(List<Criterion> matchCriteria) {
        this.matchCriteria = matchCriteria;
        return this;
    }

    /**
     * Get the actions property: List of actions which will be applied on a match.
     * 
     * @return the actions value.
     */
    public List<Action> actions() {
        return this.actions;
    }

    /**
     * Set the actions property: List of actions which will be applied on a match.
     * 
     * @param actions the actions value to set.
     * @return the RouteMapRule object itself.
     */
    public RouteMapRule withActions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Get the nextStepIfMatched property: Next step after rule is evaluated. Current supported behaviors are
     * 'Continue'(to next rule) and 'Terminate'.
     * 
     * @return the nextStepIfMatched value.
     */
    public NextStep nextStepIfMatched() {
        return this.nextStepIfMatched;
    }

    /**
     * Set the nextStepIfMatched property: Next step after rule is evaluated. Current supported behaviors are
     * 'Continue'(to next rule) and 'Terminate'.
     * 
     * @param nextStepIfMatched the nextStepIfMatched value to set.
     * @return the RouteMapRule object itself.
     */
    public RouteMapRule withNextStepIfMatched(NextStep nextStepIfMatched) {
        this.nextStepIfMatched = nextStepIfMatched;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (matchCriteria() != null) {
            matchCriteria().forEach(e -> e.validate());
        }
        if (actions() != null) {
            actions().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("matchCriteria", this.matchCriteria, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextStepIfMatched",
            this.nextStepIfMatched == null ? null : this.nextStepIfMatched.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RouteMapRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RouteMapRule if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RouteMapRule.
     */
    public static RouteMapRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RouteMapRule deserializedRouteMapRule = new RouteMapRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedRouteMapRule.name = reader.getString();
                } else if ("matchCriteria".equals(fieldName)) {
                    List<Criterion> matchCriteria = reader.readArray(reader1 -> Criterion.fromJson(reader1));
                    deserializedRouteMapRule.matchCriteria = matchCriteria;
                } else if ("actions".equals(fieldName)) {
                    List<Action> actions = reader.readArray(reader1 -> Action.fromJson(reader1));
                    deserializedRouteMapRule.actions = actions;
                } else if ("nextStepIfMatched".equals(fieldName)) {
                    deserializedRouteMapRule.nextStepIfMatched = NextStep.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRouteMapRule;
        });
    }
}
