// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.RouteTableInner;
import java.io.IOException;
import java.util.List;

/**
 * Response for the ListRouteTable API service call.
 */
@Fluent
public final class RouteTableListResult implements JsonSerializable<RouteTableListResult> {
    /*
     * A list of route tables in a resource group.
     */
    private List<RouteTableInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of RouteTableListResult class.
     */
    public RouteTableListResult() {
    }

    /**
     * Get the value property: A list of route tables in a resource group.
     * 
     * @return the value value.
     */
    public List<RouteTableInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of route tables in a resource group.
     * 
     * @param value the value value to set.
     * @return the RouteTableListResult object itself.
     */
    public RouteTableListResult withValue(List<RouteTableInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the RouteTableListResult object itself.
     */
    public RouteTableListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RouteTableListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RouteTableListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RouteTableListResult.
     */
    public static RouteTableListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RouteTableListResult deserializedRouteTableListResult = new RouteTableListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<RouteTableInner> value = reader.readArray(reader1 -> RouteTableInner.fromJson(reader1));
                    deserializedRouteTableListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedRouteTableListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRouteTableListResult;
        });
    }
}
