// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.SecurityUserRuleCollectionInner;
import java.io.IOException;
import java.util.List;

/**
 * Security user configuration rule collection list result.
 */
@Fluent
public final class SecurityUserRuleCollectionListResult
    implements JsonSerializable<SecurityUserRuleCollectionListResult> {
    /*
     * A list of network manager security user configuration rule collections
     */
    private List<SecurityUserRuleCollectionInner> value;

    /*
     * Gets the URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of SecurityUserRuleCollectionListResult class.
     */
    public SecurityUserRuleCollectionListResult() {
    }

    /**
     * Get the value property: A list of network manager security user configuration rule collections.
     * 
     * @return the value value.
     */
    public List<SecurityUserRuleCollectionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of network manager security user configuration rule collections.
     * 
     * @param value the value value to set.
     * @return the SecurityUserRuleCollectionListResult object itself.
     */
    public SecurityUserRuleCollectionListResult withValue(List<SecurityUserRuleCollectionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Gets the URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Gets the URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the SecurityUserRuleCollectionListResult object itself.
     */
    public SecurityUserRuleCollectionListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecurityUserRuleCollectionListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecurityUserRuleCollectionListResult if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SecurityUserRuleCollectionListResult.
     */
    public static SecurityUserRuleCollectionListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityUserRuleCollectionListResult deserializedSecurityUserRuleCollectionListResult
                = new SecurityUserRuleCollectionListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<SecurityUserRuleCollectionInner> value
                        = reader.readArray(reader1 -> SecurityUserRuleCollectionInner.fromJson(reader1));
                    deserializedSecurityUserRuleCollectionListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedSecurityUserRuleCollectionListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecurityUserRuleCollectionListResult;
        });
    }
}
