// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters that define the representation of topology.
 */
@Fluent
public final class TopologyParameters implements JsonSerializable<TopologyParameters> {
    /*
     * The name of the target resource group to perform topology on.
     */
    private String targetResourceGroupName;

    /*
     * The reference to the Virtual Network resource.
     */
    private SubResource targetVirtualNetwork;

    /*
     * The reference to the Subnet resource.
     */
    private SubResource targetSubnet;

    /**
     * Creates an instance of TopologyParameters class.
     */
    public TopologyParameters() {
    }

    /**
     * Get the targetResourceGroupName property: The name of the target resource group to perform topology on.
     * 
     * @return the targetResourceGroupName value.
     */
    public String targetResourceGroupName() {
        return this.targetResourceGroupName;
    }

    /**
     * Set the targetResourceGroupName property: The name of the target resource group to perform topology on.
     * 
     * @param targetResourceGroupName the targetResourceGroupName value to set.
     * @return the TopologyParameters object itself.
     */
    public TopologyParameters withTargetResourceGroupName(String targetResourceGroupName) {
        this.targetResourceGroupName = targetResourceGroupName;
        return this;
    }

    /**
     * Get the targetVirtualNetwork property: The reference to the Virtual Network resource.
     * 
     * @return the targetVirtualNetwork value.
     */
    public SubResource targetVirtualNetwork() {
        return this.targetVirtualNetwork;
    }

    /**
     * Set the targetVirtualNetwork property: The reference to the Virtual Network resource.
     * 
     * @param targetVirtualNetwork the targetVirtualNetwork value to set.
     * @return the TopologyParameters object itself.
     */
    public TopologyParameters withTargetVirtualNetwork(SubResource targetVirtualNetwork) {
        this.targetVirtualNetwork = targetVirtualNetwork;
        return this;
    }

    /**
     * Get the targetSubnet property: The reference to the Subnet resource.
     * 
     * @return the targetSubnet value.
     */
    public SubResource targetSubnet() {
        return this.targetSubnet;
    }

    /**
     * Set the targetSubnet property: The reference to the Subnet resource.
     * 
     * @param targetSubnet the targetSubnet value to set.
     * @return the TopologyParameters object itself.
     */
    public TopologyParameters withTargetSubnet(SubResource targetSubnet) {
        this.targetSubnet = targetSubnet;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetResourceGroupName", this.targetResourceGroupName);
        jsonWriter.writeJsonField("targetVirtualNetwork", this.targetVirtualNetwork);
        jsonWriter.writeJsonField("targetSubnet", this.targetSubnet);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TopologyParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TopologyParameters if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TopologyParameters.
     */
    public static TopologyParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TopologyParameters deserializedTopologyParameters = new TopologyParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targetResourceGroupName".equals(fieldName)) {
                    deserializedTopologyParameters.targetResourceGroupName = reader.getString();
                } else if ("targetVirtualNetwork".equals(fieldName)) {
                    deserializedTopologyParameters.targetVirtualNetwork = SubResource.fromJson(reader);
                } else if ("targetSubnet".equals(fieldName)) {
                    deserializedTopologyParameters.targetSubnet = SubResource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTopologyParameters;
        });
    }
}
