// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents a single IP configuration properties.
 */
@Fluent
public final class VirtualApplianceIpConfigurationProperties
    implements JsonSerializable<VirtualApplianceIpConfigurationProperties> {
    /*
     * Whether or not this is primary IP configuration of the NIC.
     */
    private Boolean primary;

    /**
     * Creates an instance of VirtualApplianceIpConfigurationProperties class.
     */
    public VirtualApplianceIpConfigurationProperties() {
    }

    /**
     * Get the primary property: Whether or not this is primary IP configuration of the NIC.
     * 
     * @return the primary value.
     */
    public Boolean primary() {
        return this.primary;
    }

    /**
     * Set the primary property: Whether or not this is primary IP configuration of the NIC.
     * 
     * @param primary the primary value to set.
     * @return the VirtualApplianceIpConfigurationProperties object itself.
     */
    public VirtualApplianceIpConfigurationProperties withPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("primary", this.primary);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualApplianceIpConfigurationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualApplianceIpConfigurationProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualApplianceIpConfigurationProperties.
     */
    public static VirtualApplianceIpConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualApplianceIpConfigurationProperties deserializedVirtualApplianceIpConfigurationProperties
                = new VirtualApplianceIpConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("primary".equals(fieldName)) {
                    deserializedVirtualApplianceIpConfigurationProperties.primary
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualApplianceIpConfigurationProperties;
        });
    }
}
