// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents a single NIC configuration.
 */
@Fluent
public final class VirtualApplianceNetworkInterfaceConfiguration
    implements JsonSerializable<VirtualApplianceNetworkInterfaceConfiguration> {
    /*
     * NIC type. This should be either PublicNic or PrivateNic.
     */
    private NicTypeInRequest nicType;

    /*
     * Represents a single NIC configuration properties.
     */
    private VirtualApplianceNetworkInterfaceConfigurationProperties properties;

    /**
     * Creates an instance of VirtualApplianceNetworkInterfaceConfiguration class.
     */
    public VirtualApplianceNetworkInterfaceConfiguration() {
    }

    /**
     * Get the nicType property: NIC type. This should be either PublicNic or PrivateNic.
     * 
     * @return the nicType value.
     */
    public NicTypeInRequest nicType() {
        return this.nicType;
    }

    /**
     * Set the nicType property: NIC type. This should be either PublicNic or PrivateNic.
     * 
     * @param nicType the nicType value to set.
     * @return the VirtualApplianceNetworkInterfaceConfiguration object itself.
     */
    public VirtualApplianceNetworkInterfaceConfiguration withNicType(NicTypeInRequest nicType) {
        this.nicType = nicType;
        return this;
    }

    /**
     * Get the properties property: Represents a single NIC configuration properties.
     * 
     * @return the properties value.
     */
    public VirtualApplianceNetworkInterfaceConfigurationProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Represents a single NIC configuration properties.
     * 
     * @param properties the properties value to set.
     * @return the VirtualApplianceNetworkInterfaceConfiguration object itself.
     */
    public VirtualApplianceNetworkInterfaceConfiguration
        withProperties(VirtualApplianceNetworkInterfaceConfigurationProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.nicType == null ? null : this.nicType.toString());
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualApplianceNetworkInterfaceConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualApplianceNetworkInterfaceConfiguration if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualApplianceNetworkInterfaceConfiguration.
     */
    public static VirtualApplianceNetworkInterfaceConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualApplianceNetworkInterfaceConfiguration deserializedVirtualApplianceNetworkInterfaceConfiguration
                = new VirtualApplianceNetworkInterfaceConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedVirtualApplianceNetworkInterfaceConfiguration.nicType
                        = NicTypeInRequest.fromString(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedVirtualApplianceNetworkInterfaceConfiguration.properties
                        = VirtualApplianceNetworkInterfaceConfigurationProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualApplianceNetworkInterfaceConfiguration;
        });
    }
}
