// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Collection of SecurityProviders.
 */
@Fluent
public final class VirtualWanSecurityProvider implements JsonSerializable<VirtualWanSecurityProvider> {
    /*
     * Name of the security provider.
     */
    private String name;

    /*
     * Url of the security provider.
     */
    private String url;

    /*
     * Name of the security provider.
     */
    private VirtualWanSecurityProviderType type;

    /**
     * Creates an instance of VirtualWanSecurityProvider class.
     */
    public VirtualWanSecurityProvider() {
    }

    /**
     * Get the name property: Name of the security provider.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the security provider.
     * 
     * @param name the name value to set.
     * @return the VirtualWanSecurityProvider object itself.
     */
    public VirtualWanSecurityProvider withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the url property: Url of the security provider.
     * 
     * @return the url value.
     */
    public String url() {
        return this.url;
    }

    /**
     * Set the url property: Url of the security provider.
     * 
     * @param url the url value to set.
     * @return the VirtualWanSecurityProvider object itself.
     */
    public VirtualWanSecurityProvider withUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * Get the type property: Name of the security provider.
     * 
     * @return the type value.
     */
    public VirtualWanSecurityProviderType type() {
        return this.type;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("url", this.url);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualWanSecurityProvider from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualWanSecurityProvider if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualWanSecurityProvider.
     */
    public static VirtualWanSecurityProvider fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualWanSecurityProvider deserializedVirtualWanSecurityProvider = new VirtualWanSecurityProvider();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedVirtualWanSecurityProvider.name = reader.getString();
                } else if ("url".equals(fieldName)) {
                    deserializedVirtualWanSecurityProvider.url = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedVirtualWanSecurityProvider.type
                        = VirtualWanSecurityProviderType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualWanSecurityProvider;
        });
    }
}
