/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCrossConnectionPeeringProperties;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitPeeringConfig;
import com.azure.resourcemanager.network.models.ExpressRoutePeeringState;
import com.azure.resourcemanager.network.models.ExpressRoutePeeringType;
import com.azure.resourcemanager.network.models.Ipv6ExpressRouteCircuitPeeringConfig;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class ExpressRouteCrossConnectionPeeringInner
extends SubResource {
    private ExpressRouteCrossConnectionPeeringProperties innerProperties;
    private String name;
    private String etag;

    private ExpressRouteCrossConnectionPeeringProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public ExpressRouteCrossConnectionPeeringInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public ExpressRouteCrossConnectionPeeringInner withId(String id) {
        super.withId(id);
        return this;
    }

    public ExpressRoutePeeringType peeringType() {
        return this.innerProperties() == null ? null : this.innerProperties().peeringType();
    }

    public ExpressRouteCrossConnectionPeeringInner withPeeringType(ExpressRoutePeeringType peeringType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCrossConnectionPeeringProperties();
        }
        this.innerProperties().withPeeringType(peeringType);
        return this;
    }

    public ExpressRoutePeeringState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public ExpressRouteCrossConnectionPeeringInner withState(ExpressRoutePeeringState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCrossConnectionPeeringProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    public Integer azureAsn() {
        return this.innerProperties() == null ? null : this.innerProperties().azureAsn();
    }

    public Long peerAsn() {
        return this.innerProperties() == null ? null : this.innerProperties().peerAsn();
    }

    public ExpressRouteCrossConnectionPeeringInner withPeerAsn(Long peerAsn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCrossConnectionPeeringProperties();
        }
        this.innerProperties().withPeerAsn(peerAsn);
        return this;
    }

    public String primaryPeerAddressPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().primaryPeerAddressPrefix();
    }

    public ExpressRouteCrossConnectionPeeringInner withPrimaryPeerAddressPrefix(String primaryPeerAddressPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCrossConnectionPeeringProperties();
        }
        this.innerProperties().withPrimaryPeerAddressPrefix(primaryPeerAddressPrefix);
        return this;
    }

    public String secondaryPeerAddressPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().secondaryPeerAddressPrefix();
    }

    public ExpressRouteCrossConnectionPeeringInner withSecondaryPeerAddressPrefix(String secondaryPeerAddressPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCrossConnectionPeeringProperties();
        }
        this.innerProperties().withSecondaryPeerAddressPrefix(secondaryPeerAddressPrefix);
        return this;
    }

    public String primaryAzurePort() {
        return this.innerProperties() == null ? null : this.innerProperties().primaryAzurePort();
    }

    public String secondaryAzurePort() {
        return this.innerProperties() == null ? null : this.innerProperties().secondaryAzurePort();
    }

    public String sharedKey() {
        return this.innerProperties() == null ? null : this.innerProperties().sharedKey();
    }

    public ExpressRouteCrossConnectionPeeringInner withSharedKey(String sharedKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCrossConnectionPeeringProperties();
        }
        this.innerProperties().withSharedKey(sharedKey);
        return this;
    }

    public Integer vlanId() {
        return this.innerProperties() == null ? null : this.innerProperties().vlanId();
    }

    public ExpressRouteCrossConnectionPeeringInner withVlanId(Integer vlanId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCrossConnectionPeeringProperties();
        }
        this.innerProperties().withVlanId(vlanId);
        return this;
    }

    public ExpressRouteCircuitPeeringConfig microsoftPeeringConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().microsoftPeeringConfig();
    }

    public ExpressRouteCrossConnectionPeeringInner withMicrosoftPeeringConfig(ExpressRouteCircuitPeeringConfig microsoftPeeringConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCrossConnectionPeeringProperties();
        }
        this.innerProperties().withMicrosoftPeeringConfig(microsoftPeeringConfig);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String gatewayManagerEtag() {
        return this.innerProperties() == null ? null : this.innerProperties().gatewayManagerEtag();
    }

    public ExpressRouteCrossConnectionPeeringInner withGatewayManagerEtag(String gatewayManagerEtag) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCrossConnectionPeeringProperties();
        }
        this.innerProperties().withGatewayManagerEtag(gatewayManagerEtag);
        return this;
    }

    public String lastModifiedBy() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedBy();
    }

    public Ipv6ExpressRouteCircuitPeeringConfig ipv6PeeringConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().ipv6PeeringConfig();
    }

    public ExpressRouteCrossConnectionPeeringInner withIpv6PeeringConfig(Ipv6ExpressRouteCircuitPeeringConfig ipv6PeeringConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCrossConnectionPeeringProperties();
        }
        this.innerProperties().withIpv6PeeringConfig(ipv6PeeringConfig);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteCrossConnectionPeeringInner fromJson(JsonReader jsonReader) throws IOException {
        return (ExpressRouteCrossConnectionPeeringInner)((Object)jsonReader.readObject(reader -> {
            ExpressRouteCrossConnectionPeeringInner deserializedExpressRouteCrossConnectionPeeringInner = new ExpressRouteCrossConnectionPeeringInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionPeeringInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionPeeringInner.innerProperties = ExpressRouteCrossConnectionPeeringProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionPeeringInner.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedExpressRouteCrossConnectionPeeringInner.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteCrossConnectionPeeringInner;
        }));
    }
}

