/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.GatewayCustomBgpIpAddressIpConfiguration;
import com.azure.resourcemanager.network.models.IpsecPolicy;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.TrafficSelectorPolicy;
import com.azure.resourcemanager.network.models.TunnelConnectionHealth;
import com.azure.resourcemanager.network.models.VirtualNetworkConnectionGatewayReference;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionMode;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionProtocol;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionStatus;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionType;
import java.io.IOException;
import java.util.List;

public final class VirtualNetworkGatewayConnectionListEntityPropertiesFormat
implements JsonSerializable<VirtualNetworkGatewayConnectionListEntityPropertiesFormat> {
    private String authorizationKey;
    private VirtualNetworkConnectionGatewayReference virtualNetworkGateway1;
    private VirtualNetworkConnectionGatewayReference virtualNetworkGateway2;
    private VirtualNetworkConnectionGatewayReference localNetworkGateway2;
    private VirtualNetworkGatewayConnectionType connectionType;
    private VirtualNetworkGatewayConnectionProtocol connectionProtocol;
    private Integer routingWeight;
    private VirtualNetworkGatewayConnectionMode connectionMode;
    private String sharedKey;
    private VirtualNetworkGatewayConnectionStatus connectionStatus;
    private List<TunnelConnectionHealth> tunnelConnectionStatus;
    private Long egressBytesTransferred;
    private Long ingressBytesTransferred;
    private SubResource peer;
    private Boolean enableBgp;
    private List<GatewayCustomBgpIpAddressIpConfiguration> gatewayCustomBgpIpAddresses;
    private Boolean usePolicyBasedTrafficSelectors;
    private List<IpsecPolicy> ipsecPolicies;
    private List<TrafficSelectorPolicy> trafficSelectorPolicies;
    private String resourceGuid;
    private ProvisioningState provisioningState;
    private Boolean expressRouteGatewayBypass;
    private Boolean enablePrivateLinkFastPath;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualNetworkGatewayConnectionListEntityPropertiesFormat.class);

    public String authorizationKey() {
        return this.authorizationKey;
    }

    public VirtualNetworkGatewayConnectionListEntityPropertiesFormat withAuthorizationKey(String authorizationKey) {
        this.authorizationKey = authorizationKey;
        return this;
    }

    public VirtualNetworkConnectionGatewayReference virtualNetworkGateway1() {
        return this.virtualNetworkGateway1;
    }

    public VirtualNetworkGatewayConnectionListEntityPropertiesFormat withVirtualNetworkGateway1(VirtualNetworkConnectionGatewayReference virtualNetworkGateway1) {
        this.virtualNetworkGateway1 = virtualNetworkGateway1;
        return this;
    }

    public VirtualNetworkConnectionGatewayReference virtualNetworkGateway2() {
        return this.virtualNetworkGateway2;
    }

    public VirtualNetworkGatewayConnectionListEntityPropertiesFormat withVirtualNetworkGateway2(VirtualNetworkConnectionGatewayReference virtualNetworkGateway2) {
        this.virtualNetworkGateway2 = virtualNetworkGateway2;
        return this;
    }

    public VirtualNetworkConnectionGatewayReference localNetworkGateway2() {
        return this.localNetworkGateway2;
    }

    public VirtualNetworkGatewayConnectionListEntityPropertiesFormat withLocalNetworkGateway2(VirtualNetworkConnectionGatewayReference localNetworkGateway2) {
        this.localNetworkGateway2 = localNetworkGateway2;
        return this;
    }

    public VirtualNetworkGatewayConnectionType connectionType() {
        return this.connectionType;
    }

    public VirtualNetworkGatewayConnectionListEntityPropertiesFormat withConnectionType(VirtualNetworkGatewayConnectionType connectionType) {
        this.connectionType = connectionType;
        return this;
    }

    public VirtualNetworkGatewayConnectionProtocol connectionProtocol() {
        return this.connectionProtocol;
    }

    public VirtualNetworkGatewayConnectionListEntityPropertiesFormat withConnectionProtocol(VirtualNetworkGatewayConnectionProtocol connectionProtocol) {
        this.connectionProtocol = connectionProtocol;
        return this;
    }

    public Integer routingWeight() {
        return this.routingWeight;
    }

    public VirtualNetworkGatewayConnectionListEntityPropertiesFormat withRoutingWeight(Integer routingWeight) {
        this.routingWeight = routingWeight;
        return this;
    }

    public VirtualNetworkGatewayConnectionMode connectionMode() {
        return this.connectionMode;
    }

    public VirtualNetworkGatewayConnectionListEntityPropertiesFormat withConnectionMode(VirtualNetworkGatewayConnectionMode connectionMode) {
        this.connectionMode = connectionMode;
        return this;
    }

    public String sharedKey() {
        return this.sharedKey;
    }

    public VirtualNetworkGatewayConnectionListEntityPropertiesFormat withSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
        return this;
    }

    public VirtualNetworkGatewayConnectionStatus connectionStatus() {
        return this.connectionStatus;
    }

    public List<TunnelConnectionHealth> tunnelConnectionStatus() {
        return this.tunnelConnectionStatus;
    }

    public Long egressBytesTransferred() {
        return this.egressBytesTransferred;
    }

    public Long ingressBytesTransferred() {
        return this.ingressBytesTransferred;
    }

    public SubResource peer() {
        return this.peer;
    }

    public VirtualNetworkGatewayConnectionListEntityPropertiesFormat withPeer(SubResource peer) {
        this.peer = peer;
        return this;
    }

    public Boolean enableBgp() {
        return this.enableBgp;
    }

    public VirtualNetworkGatewayConnectionListEntityPropertiesFormat withEnableBgp(Boolean enableBgp) {
        this.enableBgp = enableBgp;
        return this;
    }

    public List<GatewayCustomBgpIpAddressIpConfiguration> gatewayCustomBgpIpAddresses() {
        return this.gatewayCustomBgpIpAddresses;
    }

    public VirtualNetworkGatewayConnectionListEntityPropertiesFormat withGatewayCustomBgpIpAddresses(List<GatewayCustomBgpIpAddressIpConfiguration> gatewayCustomBgpIpAddresses) {
        this.gatewayCustomBgpIpAddresses = gatewayCustomBgpIpAddresses;
        return this;
    }

    public Boolean usePolicyBasedTrafficSelectors() {
        return this.usePolicyBasedTrafficSelectors;
    }

    public VirtualNetworkGatewayConnectionListEntityPropertiesFormat withUsePolicyBasedTrafficSelectors(Boolean usePolicyBasedTrafficSelectors) {
        this.usePolicyBasedTrafficSelectors = usePolicyBasedTrafficSelectors;
        return this;
    }

    public List<IpsecPolicy> ipsecPolicies() {
        return this.ipsecPolicies;
    }

    public VirtualNetworkGatewayConnectionListEntityPropertiesFormat withIpsecPolicies(List<IpsecPolicy> ipsecPolicies) {
        this.ipsecPolicies = ipsecPolicies;
        return this;
    }

    public List<TrafficSelectorPolicy> trafficSelectorPolicies() {
        return this.trafficSelectorPolicies;
    }

    public VirtualNetworkGatewayConnectionListEntityPropertiesFormat withTrafficSelectorPolicies(List<TrafficSelectorPolicy> trafficSelectorPolicies) {
        this.trafficSelectorPolicies = trafficSelectorPolicies;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Boolean expressRouteGatewayBypass() {
        return this.expressRouteGatewayBypass;
    }

    public VirtualNetworkGatewayConnectionListEntityPropertiesFormat withExpressRouteGatewayBypass(Boolean expressRouteGatewayBypass) {
        this.expressRouteGatewayBypass = expressRouteGatewayBypass;
        return this;
    }

    public Boolean enablePrivateLinkFastPath() {
        return this.enablePrivateLinkFastPath;
    }

    public VirtualNetworkGatewayConnectionListEntityPropertiesFormat withEnablePrivateLinkFastPath(Boolean enablePrivateLinkFastPath) {
        this.enablePrivateLinkFastPath = enablePrivateLinkFastPath;
        return this;
    }

    public void validate() {
        if (this.virtualNetworkGateway1() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property virtualNetworkGateway1 in model VirtualNetworkGatewayConnectionListEntityPropertiesFormat"));
        }
        this.virtualNetworkGateway1().validate();
        if (this.virtualNetworkGateway2() != null) {
            this.virtualNetworkGateway2().validate();
        }
        if (this.localNetworkGateway2() != null) {
            this.localNetworkGateway2().validate();
        }
        if (this.connectionType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property connectionType in model VirtualNetworkGatewayConnectionListEntityPropertiesFormat"));
        }
        if (this.tunnelConnectionStatus() != null) {
            this.tunnelConnectionStatus().forEach(e -> e.validate());
        }
        if (this.gatewayCustomBgpIpAddresses() != null) {
            this.gatewayCustomBgpIpAddresses().forEach(e -> e.validate());
        }
        if (this.ipsecPolicies() != null) {
            this.ipsecPolicies().forEach(e -> e.validate());
        }
        if (this.trafficSelectorPolicies() != null) {
            this.trafficSelectorPolicies().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("virtualNetworkGateway1", (JsonSerializable)this.virtualNetworkGateway1);
        jsonWriter.writeStringField("connectionType", this.connectionType == null ? null : this.connectionType.toString());
        jsonWriter.writeStringField("authorizationKey", this.authorizationKey);
        jsonWriter.writeJsonField("virtualNetworkGateway2", (JsonSerializable)this.virtualNetworkGateway2);
        jsonWriter.writeJsonField("localNetworkGateway2", (JsonSerializable)this.localNetworkGateway2);
        jsonWriter.writeStringField("connectionProtocol", this.connectionProtocol == null ? null : this.connectionProtocol.toString());
        jsonWriter.writeNumberField("routingWeight", (Number)this.routingWeight);
        jsonWriter.writeStringField("connectionMode", this.connectionMode == null ? null : this.connectionMode.toString());
        jsonWriter.writeStringField("sharedKey", this.sharedKey);
        jsonWriter.writeJsonField("peer", (JsonSerializable)this.peer);
        jsonWriter.writeBooleanField("enableBgp", this.enableBgp);
        jsonWriter.writeArrayField("gatewayCustomBgpIpAddresses", this.gatewayCustomBgpIpAddresses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("usePolicyBasedTrafficSelectors", this.usePolicyBasedTrafficSelectors);
        jsonWriter.writeArrayField("ipsecPolicies", this.ipsecPolicies, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("trafficSelectorPolicies", this.trafficSelectorPolicies, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("expressRouteGatewayBypass", this.expressRouteGatewayBypass);
        jsonWriter.writeBooleanField("enablePrivateLinkFastPath", this.enablePrivateLinkFastPath);
        return jsonWriter.writeEndObject();
    }

    public static VirtualNetworkGatewayConnectionListEntityPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualNetworkGatewayConnectionListEntityPropertiesFormat)jsonReader.readObject(reader -> {
            VirtualNetworkGatewayConnectionListEntityPropertiesFormat deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat = new VirtualNetworkGatewayConnectionListEntityPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("virtualNetworkGateway1".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.virtualNetworkGateway1 = VirtualNetworkConnectionGatewayReference.fromJson(reader);
                    continue;
                }
                if ("connectionType".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.connectionType = VirtualNetworkGatewayConnectionType.fromString(reader.getString());
                    continue;
                }
                if ("authorizationKey".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.authorizationKey = reader.getString();
                    continue;
                }
                if ("virtualNetworkGateway2".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.virtualNetworkGateway2 = VirtualNetworkConnectionGatewayReference.fromJson(reader);
                    continue;
                }
                if ("localNetworkGateway2".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.localNetworkGateway2 = VirtualNetworkConnectionGatewayReference.fromJson(reader);
                    continue;
                }
                if ("connectionProtocol".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.connectionProtocol = VirtualNetworkGatewayConnectionProtocol.fromString(reader.getString());
                    continue;
                }
                if ("routingWeight".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.routingWeight = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("connectionMode".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.connectionMode = VirtualNetworkGatewayConnectionMode.fromString(reader.getString());
                    continue;
                }
                if ("sharedKey".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.sharedKey = reader.getString();
                    continue;
                }
                if ("connectionStatus".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.connectionStatus = VirtualNetworkGatewayConnectionStatus.fromString(reader.getString());
                    continue;
                }
                if ("tunnelConnectionStatus".equals(fieldName)) {
                    List tunnelConnectionStatus;
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.tunnelConnectionStatus = tunnelConnectionStatus = reader.readArray(reader1 -> TunnelConnectionHealth.fromJson(reader1));
                    continue;
                }
                if ("egressBytesTransferred".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.egressBytesTransferred = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("ingressBytesTransferred".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.ingressBytesTransferred = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("peer".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.peer = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("enableBgp".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.enableBgp = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("gatewayCustomBgpIpAddresses".equals(fieldName)) {
                    List gatewayCustomBgpIpAddresses;
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.gatewayCustomBgpIpAddresses = gatewayCustomBgpIpAddresses = reader.readArray(reader1 -> GatewayCustomBgpIpAddressIpConfiguration.fromJson(reader1));
                    continue;
                }
                if ("usePolicyBasedTrafficSelectors".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.usePolicyBasedTrafficSelectors = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("ipsecPolicies".equals(fieldName)) {
                    List ipsecPolicies;
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.ipsecPolicies = ipsecPolicies = reader.readArray(reader1 -> IpsecPolicy.fromJson(reader1));
                    continue;
                }
                if ("trafficSelectorPolicies".equals(fieldName)) {
                    List trafficSelectorPolicies;
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.trafficSelectorPolicies = trafficSelectorPolicies = reader.readArray(reader1 -> TrafficSelectorPolicy.fromJson(reader1));
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.resourceGuid = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("expressRouteGatewayBypass".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.expressRouteGatewayBypass = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enablePrivateLinkFastPath".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat.enablePrivateLinkFastPath = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualNetworkGatewayConnectionListEntityPropertiesFormat;
        });
    }
}

