/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ContainerNetworkInterfacePropertiesFormat;
import com.azure.resourcemanager.network.models.Container;
import com.azure.resourcemanager.network.models.ContainerNetworkInterfaceConfiguration;
import com.azure.resourcemanager.network.models.ContainerNetworkInterfaceIpConfiguration;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ContainerNetworkInterface
extends SubResource {
    private ContainerNetworkInterfacePropertiesFormat innerProperties;
    private String name;
    private String type;
    private String etag;

    private ContainerNetworkInterfacePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public ContainerNetworkInterface withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String etag() {
        return this.etag;
    }

    public ContainerNetworkInterface withId(String id) {
        super.withId(id);
        return this;
    }

    public ContainerNetworkInterfaceConfiguration containerNetworkInterfaceConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().containerNetworkInterfaceConfiguration();
    }

    public Container container() {
        return this.innerProperties() == null ? null : this.innerProperties().container();
    }

    public ContainerNetworkInterface withContainer(Container container) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerNetworkInterfacePropertiesFormat();
        }
        this.innerProperties().withContainer(container);
        return this;
    }

    public List<ContainerNetworkInterfaceIpConfiguration> ipConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurations();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static ContainerNetworkInterface fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerNetworkInterface)((Object)jsonReader.readObject(reader -> {
            ContainerNetworkInterface deserializedContainerNetworkInterface = new ContainerNetworkInterface();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedContainerNetworkInterface.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedContainerNetworkInterface.innerProperties = ContainerNetworkInterfacePropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedContainerNetworkInterface.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedContainerNetworkInterface.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedContainerNetworkInterface.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerNetworkInterface;
        }));
    }
}

