/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class TrafficSelectorPolicy
implements JsonSerializable<TrafficSelectorPolicy> {
    private List<String> localAddressRanges;
    private List<String> remoteAddressRanges;
    private static final ClientLogger LOGGER = new ClientLogger(TrafficSelectorPolicy.class);

    public List<String> localAddressRanges() {
        return this.localAddressRanges;
    }

    public TrafficSelectorPolicy withLocalAddressRanges(List<String> localAddressRanges) {
        this.localAddressRanges = localAddressRanges;
        return this;
    }

    public List<String> remoteAddressRanges() {
        return this.remoteAddressRanges;
    }

    public TrafficSelectorPolicy withRemoteAddressRanges(List<String> remoteAddressRanges) {
        this.remoteAddressRanges = remoteAddressRanges;
        return this;
    }

    public void validate() {
        if (this.localAddressRanges() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property localAddressRanges in model TrafficSelectorPolicy"));
        }
        if (this.remoteAddressRanges() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property remoteAddressRanges in model TrafficSelectorPolicy"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("localAddressRanges", this.localAddressRanges, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("remoteAddressRanges", this.remoteAddressRanges, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static TrafficSelectorPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (TrafficSelectorPolicy)jsonReader.readObject(reader -> {
            TrafficSelectorPolicy deserializedTrafficSelectorPolicy = new TrafficSelectorPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("localAddressRanges".equals(fieldName)) {
                    List localAddressRanges;
                    deserializedTrafficSelectorPolicy.localAddressRanges = localAddressRanges = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("remoteAddressRanges".equals(fieldName)) {
                    List remoteAddressRanges;
                    deserializedTrafficSelectorPolicy.remoteAddressRanges = remoteAddressRanges = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTrafficSelectorPolicy;
        });
    }
}

