// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ExtendedLocation;
import com.azure.resourcemanager.network.models.PrivateLinkServicePropertiesAutoApproval;
import com.azure.resourcemanager.network.models.PrivateLinkServicePropertiesVisibility;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Private link service resource.
 */
@Fluent
public final class PrivateLinkServiceInner extends Resource {
    /*
     * The extended location of the load balancer.
     */
    private ExtendedLocation extendedLocation;

    /*
     * Properties of the private link service.
     */
    private PrivateLinkServiceProperties innerProperties;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * Resource ID.
     */
    private String id;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /**
     * Creates an instance of PrivateLinkServiceInner class.
     */
    public PrivateLinkServiceInner() {
    }

    /**
     * Get the extendedLocation property: The extended location of the load balancer.
     * 
     * @return the extendedLocation value.
     */
    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    /**
     * Set the extendedLocation property: The extended location of the load balancer.
     * 
     * @param extendedLocation the extendedLocation value to set.
     * @return the PrivateLinkServiceInner object itself.
     */
    public PrivateLinkServiceInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    /**
     * Get the innerProperties property: Properties of the private link service.
     * 
     * @return the innerProperties value.
     */
    private PrivateLinkServiceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the id property: Resource ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID.
     * 
     * @param id the id value to set.
     * @return the PrivateLinkServiceInner object itself.
     */
    public PrivateLinkServiceInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PrivateLinkServiceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PrivateLinkServiceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the loadBalancerFrontendIpConfigurations property: An array of references to the load balancer IP
     * configurations.
     * 
     * @return the loadBalancerFrontendIpConfigurations value.
     */
    public List<FrontendIpConfigurationInner> loadBalancerFrontendIpConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().loadBalancerFrontendIpConfigurations();
    }

    /**
     * Set the loadBalancerFrontendIpConfigurations property: An array of references to the load balancer IP
     * configurations.
     * 
     * @param loadBalancerFrontendIpConfigurations the loadBalancerFrontendIpConfigurations value to set.
     * @return the PrivateLinkServiceInner object itself.
     */
    public PrivateLinkServiceInner withLoadBalancerFrontendIpConfigurations(
        List<FrontendIpConfigurationInner> loadBalancerFrontendIpConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceProperties();
        }
        this.innerProperties().withLoadBalancerFrontendIpConfigurations(loadBalancerFrontendIpConfigurations);
        return this;
    }

    /**
     * Get the ipConfigurations property: An array of private link service IP configurations.
     * 
     * @return the ipConfigurations value.
     */
    public List<PrivateLinkServiceIpConfigurationInner> ipConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurations();
    }

    /**
     * Set the ipConfigurations property: An array of private link service IP configurations.
     * 
     * @param ipConfigurations the ipConfigurations value to set.
     * @return the PrivateLinkServiceInner object itself.
     */
    public PrivateLinkServiceInner withIpConfigurations(List<PrivateLinkServiceIpConfigurationInner> ipConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceProperties();
        }
        this.innerProperties().withIpConfigurations(ipConfigurations);
        return this;
    }

    /**
     * Get the destinationIpAddress property: The destination IP address of the private link service.
     * 
     * @return the destinationIpAddress value.
     */
    public String destinationIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationIpAddress();
    }

    /**
     * Set the destinationIpAddress property: The destination IP address of the private link service.
     * 
     * @param destinationIpAddress the destinationIpAddress value to set.
     * @return the PrivateLinkServiceInner object itself.
     */
    public PrivateLinkServiceInner withDestinationIpAddress(String destinationIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceProperties();
        }
        this.innerProperties().withDestinationIpAddress(destinationIpAddress);
        return this;
    }

    /**
     * Get the networkInterfaces property: An array of references to the network interfaces created for this private
     * link service.
     * 
     * @return the networkInterfaces value.
     */
    public List<NetworkInterfaceInner> networkInterfaces() {
        return this.innerProperties() == null ? null : this.innerProperties().networkInterfaces();
    }

    /**
     * Get the provisioningState property: The provisioning state of the private link service resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the privateEndpointConnections property: An array of list about connections to the private endpoint.
     * 
     * @return the privateEndpointConnections value.
     */
    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    /**
     * Get the visibility property: The visibility list of the private link service.
     * 
     * @return the visibility value.
     */
    public PrivateLinkServicePropertiesVisibility visibility() {
        return this.innerProperties() == null ? null : this.innerProperties().visibility();
    }

    /**
     * Set the visibility property: The visibility list of the private link service.
     * 
     * @param visibility the visibility value to set.
     * @return the PrivateLinkServiceInner object itself.
     */
    public PrivateLinkServiceInner withVisibility(PrivateLinkServicePropertiesVisibility visibility) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceProperties();
        }
        this.innerProperties().withVisibility(visibility);
        return this;
    }

    /**
     * Get the autoApproval property: The auto-approval list of the private link service.
     * 
     * @return the autoApproval value.
     */
    public PrivateLinkServicePropertiesAutoApproval autoApproval() {
        return this.innerProperties() == null ? null : this.innerProperties().autoApproval();
    }

    /**
     * Set the autoApproval property: The auto-approval list of the private link service.
     * 
     * @param autoApproval the autoApproval value to set.
     * @return the PrivateLinkServiceInner object itself.
     */
    public PrivateLinkServiceInner withAutoApproval(PrivateLinkServicePropertiesAutoApproval autoApproval) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceProperties();
        }
        this.innerProperties().withAutoApproval(autoApproval);
        return this;
    }

    /**
     * Get the fqdns property: The list of Fqdn.
     * 
     * @return the fqdns value.
     */
    public List<String> fqdns() {
        return this.innerProperties() == null ? null : this.innerProperties().fqdns();
    }

    /**
     * Set the fqdns property: The list of Fqdn.
     * 
     * @param fqdns the fqdns value to set.
     * @return the PrivateLinkServiceInner object itself.
     */
    public PrivateLinkServiceInner withFqdns(List<String> fqdns) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceProperties();
        }
        this.innerProperties().withFqdns(fqdns);
        return this;
    }

    /**
     * Get the alias property: The alias of the private link service.
     * 
     * @return the alias value.
     */
    public String alias() {
        return this.innerProperties() == null ? null : this.innerProperties().alias();
    }

    /**
     * Get the enableProxyProtocol property: Whether the private link service is enabled for proxy protocol or not.
     * 
     * @return the enableProxyProtocol value.
     */
    public Boolean enableProxyProtocol() {
        return this.innerProperties() == null ? null : this.innerProperties().enableProxyProtocol();
    }

    /**
     * Set the enableProxyProtocol property: Whether the private link service is enabled for proxy protocol or not.
     * 
     * @param enableProxyProtocol the enableProxyProtocol value to set.
     * @return the PrivateLinkServiceInner object itself.
     */
    public PrivateLinkServiceInner withEnableProxyProtocol(Boolean enableProxyProtocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkServiceProperties();
        }
        this.innerProperties().withEnableProxyProtocol(enableProxyProtocol);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (extendedLocation() != null) {
            extendedLocation().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", this.extendedLocation);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PrivateLinkServiceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PrivateLinkServiceInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PrivateLinkServiceInner.
     */
    public static PrivateLinkServiceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PrivateLinkServiceInner deserializedPrivateLinkServiceInner = new PrivateLinkServiceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedPrivateLinkServiceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedPrivateLinkServiceInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedPrivateLinkServiceInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedPrivateLinkServiceInner.withTags(tags);
                } else if ("extendedLocation".equals(fieldName)) {
                    deserializedPrivateLinkServiceInner.extendedLocation = ExtendedLocation.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedPrivateLinkServiceInner.innerProperties = PrivateLinkServiceProperties.fromJson(reader);
                } else if ("etag".equals(fieldName)) {
                    deserializedPrivateLinkServiceInner.etag = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedPrivateLinkServiceInner.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPrivateLinkServiceInner;
        });
    }
}
